<?php

namespace Database\Seeders\Themes\Main;

use Botble\Base\Supports\BaseSeeder;
use Botble\Page\Database\Traits\HasPageSeeder;
use Botble\Portfolio\Models\Package;
use Botble\Portfolio\Models\Service;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Team\Models\Team;
use Botble\Testimonial\Models\Testimonial;

class PageSeeder extends BaseSeeder
{
    use HasPageSeeder;

    public function run(): void
    {
        $this->truncatePages();

        $this->uploadFiles('partners');
        $this->uploadFiles('backgrounds');
        $this->uploadFiles('shapes');
        $this->uploadFiles('general');

        $this->createPages([
            [
                'name' => 'Homepage',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'hero-banner',
                        'attributes' => [
                            'title' => "Boost your project's speed and efficiency.",
                            'subtitle' => 'Free Lifetime Update',
                            'description' => 'Access top-tier group mentoring plans and exclusive professional benefits for your team.',
                            'primary_action_label' => 'Explore Now',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'secondary_action_label' => 'Contact Us',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-phone',
                            // 'bottom_image' => $this->filePath('backgrounds/hb-bottom.png'),
                            'right_background_image' => $this->filePath('backgrounds/hb-right.png'),
                            ...collect(range(1, 3))
                                ->mapWithKeys(fn ($i) => ["shape_{$i}_image" => $this->filePath("shapes/$i.png")])
                                ->all(),
                            'floating_card_image' => $this->filePath('shapes/4.png'),
                            'floating_card_title' => 'Book A Call',
                            'floating_card_description' => 'Customer activity can be easily <br> tracked with one click',
                            'floating_card_button_label' => 'Free Update',
                        ],
                    ],
                    [
                        'name' => 'partners',
                        'attributes' => [
                            'style' => 1,
                            'quantity' => 10,
                            ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy', 'PayPal', 'Mailchimp', 'Shopify', 'Slack'])
                                ->mapWithKeys(function ($name, $index) {
                                    $index++;

                                    $imageName = $index > 8 ? rand(1, 8) : $index;

                                    return [
                                        "name_$index" => $name,
                                        "image_$index" => $this->filePath("partners/$imageName.png"),
                                        "url_$index" => 'https://google.com',
                                        "open_in_new_tab_$index" => true,
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 1,
                            'title' => 'Together, we are creating a <span>Bright Future</span>',
                            'subtitle' => 'OUR FEATURES',
                            'image' => $this->filePath('backgrounds/feature.png'),
                            'quantity' => 4,
                            ...collect([
                                [
                                    'title' => 'Work organization',
                                    'description' => 'A business consultant provides expert advice and guidance to businesses on various aspects.',
                                    'icon_image' => $this->filePath('icons/icon-1.png'),
                                ],
                                [
                                    'title' => 'Strategy Development',
                                    'description' => 'Business consultants play a crucial role by offering expert advice and guidance to companies',
                                    'icon_image' => $this->filePath('icons/icon-2.png'),
                                ],
                                [
                                    'title' => 'Data analytics',
                                    'description' => 'Consultants provide invaluable expertise to businesses, assisting them with strategic advice',
                                    'icon_image' => $this->filePath('icons/icon-3.png'),
                                ],
                                [
                                    'title' => 'Business Intelligence',
                                    'description' => 'Through their deep understanding of industry trends and best practices, consultants empower organizations',
                                    'icon_image' => $this->filePath('icons/icon-4.png'),
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                        "icon_image_$index" => $feature['icon_image'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 2,
                            'title' => 'Scalable Business for <span>Startups</span>',
                            'subtitle' => 'OUR FEATURES',
                            'checklist' => 'Success Accelerators\nStarted politician Club\nBusiness Intelligence\nData analytics',
                            'image' => $this->filePath('shapes/img-favicon.png'),
                            'floating_card_image' => $this->filePath('backgrounds/feature-2.png'),
                            'floating_card_title' => 'Transform Your Business \n Into Profession',
                            'floating_card_description' => 'Achieve Your a of Business',
                            'floating_card_button_label' => 'Free Update',
                            'floating_card_button_url' => '/contact',
                            'quantity' => 2,
                            ...collect([
                                [
                                    'title' => 'Efficiency Experts',
                                    'description' => 'A business consultant provides expert advice and guidance to businesses on various aspects.',
                                    'icon_image' => $this->filePath('icons/icon-5.png'),
                                ],
                                [
                                    'title' => 'Strategic Solutions',
                                    'description' => 'Discover why hundreds of millions people use Infinia to chat and call every day.',
                                    'icon_image' => null,
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                        "icon_image_$index" => $feature['icon_image'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 3,
                            'title' => 'Powerful agency for corporate business.',
                            'subtitle' => 'Company\'s vision',
                            'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                            'image' => $this->filePath('backgrounds/feature-3.png'),
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                            'floating_card_image' => $this->filePath('shapes/testimonial-star.png'),
                            'floating_card_title' => 'Rate For Us',
                            'floating_card_description' => 'Loved by over 4k \n happy clients',
                            'quantity' => 2,
                            ...collect([
                                [
                                    'title' => '99%',
                                    'description' => 'Genuine repeated happy customers.',
                                ],
                                [
                                    'title' => '98%',
                                    'description' => 'Trusted by companies.',
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'services',
                        'attributes' => [
                            'subtitle' => 'WHAT WE OFFERS',
                            'title' => 'Explore Our Services',
                            'description' => 'By doing a financial analysis of these statements, you can see <br> whether you have enough working capital.',
                            'service_ids' => Service::query()->pluck('id')->implode(','),
                            'background_image' => $this->filePath('backgrounds/service.png'),
                        ],
                    ],
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'title' => 'Meet Our Team',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => Team::query()->pluck('id')->implode(','),
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'subtitle' => 'OUR PLANS',
                            'title' => 'Pricing Plans',
                            'description' => '⚡We’ve got a pricing plan that’s perfect for you',
                            'package_ids' => Package::query()->pluck('id')->implode(','),
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => 1,
                            'subtitle' => 'TESTIMONIALS',
                            'title' => 'What our clients say',
                            'description' => 'Access top-tier group mentoring plans and exclusive professional benefits for your team. 🔥',
                            'testimonial_ids' => Testimonial::query()->take(4)->pluck('id')->implode(','),
                            'primary_action_label' => 'Contact Us',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-phone',
                            'secondary_action_label' => 'Help Center',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-arrow-right',
                        ],
                    ],
                    [
                        'name' => 'blog-posts',
                        'attributes' => [
                            'subtitle' => 'FROM BLOG',
                            'title' => 'Our Latest Articles',
                            'description' => 'Explore the insights and trends shaping our industry',
                            'paginate' => 3,
                            'action_label' => 'View All Articles',
                            'action_url' => '/blog',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Projects',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'projects',
                        'attributes' => [
                            'title' => 'All Case Studies',
                            'subtitle' => 'What We Offer',
                            'description' => 'We help you to bring success fast',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Services',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'services',
                        'attributes' => [
                            'subtitle' => 'WHAT WE OFFERS',
                            'title' => 'Explore Our Services',
                            'description' => 'By doing a financial analysis of these statements, you can see <br> whether you have enough working capital.',
                            'service_ids' => Service::query()->pluck('id')->implode(','),
                            'background_image' => $this->filePath('backgrounds/service.png'),
                        ],
                    ],
                    [
                        'name' => 'partners',
                        'attributes' => [
                            'style' => 2,
                            'title' => 'Loved By Developers \n Trusted By Enterprises',
                            'description' => 'We helped these brands turn online assessments into success stories.',
                            'primary_action_label' => 'View Our Partners',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-right',
                            'quantity' => 12,
                            ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy', 'Paypal', 'Mailchimp'])
                                ->mapWithKeys(function ($name, $index) {
                                    $index++;

                                    return [
                                        "name_$index" => $name,
                                        "image_$index" => $this->filePath("partners/$index.png"),
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => 2,
                            'title' => '+100k users have loved \n Infinia Conference System',
                            'description' => 'Provide your team with top-tier group mentoring \n programs and exceptional professional benefits.',
                            'testimonial_ids' => Testimonial::query()->take(6)->pluck('id')->implode(','),
                            'background_image' => $this->filePath('backgrounds/testimonial.png'),
                            'primary_action_label' => 'View All Testimonials',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '1',
                ],
            ],
            [
                'name' => 'Services v2',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'services',
                        'attributes' => [
                            'style' => '5',
                            'title' => 'Let\'s Discover Our Service <b>Our Service</b> <br> <b>Features </b> Charter',
                            'subtitle' => 'WHAT WE OFFERS',
                            'service_ids' => '1,2,3,4,5,6',
                            'primary_action_label' => 'Explore Now',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'primary_action_url' => '/contact',
                            'secondary_action_label' => 'Contact Us',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-phone-call',
                        ],
                    ],
                    [
                        'name' => 'app-downloads',
                        'attributes' => [
                            'title' => 'Manage all <br> from anywhere',
                            'subtitle' => 'Download Mobile App',
                            'description' => '⚡Don\'t miss any contact. Stay connected.',
                            'image' => $this->filePath('general/app-downloads-img.png'),
                            'features' => 'Beautiful and awesome interface | Online collaborative anytime, anywhere. | Real-time updates',
                            'quantity' => '3',
                            'name_1' => 'Apple',
                            'url_1' => 'https://www.apple.com/',
                            'image_1' => $this->filePath('general/apple-store.png'),
                            'name_2' => 'Google Play',
                            'url_2' => 'https://play.google.com/',
                            'image_2' => $this->filePath('general/google-play.png'),
                            'name_3' => 'Microsoft',
                            'url_3' => 'https://www.microsoft.com/',
                            'image_3' => $this->filePath('general/microsoft.png'),
                            'reviews_card_title' => ' Trusted by 1M+ customers',
                            'reviews_card_image' => $this->filePath('general/customer-reviews.png'),
                            'reviews_card_rate' => '4.8/5',
                            'reviews_card_data' => '26',
                            'reviews_card_unit' => 'k Reviews',
                        ],
                    ],
                    [
                        'name' => 'site-statistics',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Numbers Speaking for <br> Themselves',
                            'quantity' => '4',
                            'title_1' => 'Users Active / Month',
                            'data_1' => '500',
                            'unit_1' => 'k+',
                            'title_2' => 'New Download / Month',
                            'data_2' => '38',
                            'unit_2' => 'k',
                            'title_3' => 'Operating countries',
                            'data_3' => '150',
                            'title_4' => 'Businesses trust on the worldinfinia',
                            'data_4' => '4000',
                            'background_image' => $this->filePath('shapes/site-statistics-decorate.png'),
                            'background_color' => '#6d4df2',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => 1,
                            'subtitle' => 'TESTIMONIALS',
                            'title' => 'What our clients say',
                            'description' => 'Access top-tier group mentoring plans and exclusive professional benefits for your team. 🔥',
                            'testimonial_ids' => Testimonial::query()->take(4)->pluck('id')->implode(','),
                            'primary_action_label' => 'Contact Us',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-phone',
                            'secondary_action_label' => 'Help Center',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-arrow-right',
                        ],
                    ],
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'style' => '2',
                            'form_title' => 'Leave a message',
                            'title' => 'Thinking about a project? <br> Get in touch with us.',
                            'subtitle' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'description' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'quantity' => '3',
                            'title_1' => 'Chat with us',
                            'description_1' => 'The support team is always available 24/7',
                            'button_label_1_1' => 'Chat via Whatsapp',
                            'button_url_1_1' => 'https://www.whatsapp.com',
                            'button_icon_1_1' => 'ti ti-brand-whatsapp',
                            'button_label_2_1' => 'Chat via Viber',
                            'button_url_2_1' => 'https://www.viber.com/',
                            'button_icon_2_1' => 'ti ti-phone-call',
                            'button_label_3_1' => 'Chat via Messager',
                            'button_url_3_1' => 'https://www.facebook.com/',
                            'button_icon_3_1' => 'ti ti-brand-messenger',
                            'title_2' => 'Send us an email',
                            'description_2' => 'Our team will respond promptly to your inquiries',
                            'button_label_1_2' => 'support@infinia.com',
                            'button_url_1_2' => 'mailto:support@infinia.com',
                            'button_icon_1_2' => 'ti ti-mail',
                            'button_label_2_2' => 'sale@infinia.com',
                            'button_url_2_2' => 'mailto:sale@infinia.com',
                            'button_icon_2_2' => 'ti ti-mail',
                            'title_3' => 'For more inquiry',
                            'description_3' => 'Reach out for immediate assistance',
                            'button_label_1_3' => '+01 (24) 568 900',
                            'button_url_1_3' => 'tell:0124568900',
                            'button_icon_1_3' => 'ti ti-phone-call',
                            'background_color' => '#fff7ee',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Services v3',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'feature-tabs',
                        'attributes' => [
                            'title' => 'Building <b>enduring value</b> <br> through <b>bold</b> strategies',
                            'subtitle' => 'WHAT WE OFFERS',
                            'quantity' => '6',
                            'tab_name_1' => 'Financial Consultancy',
                            'title_1' => 'Pick Your Premium',
                            'description_1' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_1' => $this->filePath('general/feature-tabs-1.png'),
                            'feature_item_title_1_1' => 'Research planning',
                            'feature_item_description_1_1' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_1' => $this->filePath('icons/icon-14.png'),
                            'feature_item_title_2_1' => 'Investment',
                            'feature_item_description_2_1' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_1' => $this->filePath('icons/icon-15.png'),
                            'tab_name_2' => 'Business Consultancy',
                            'title_2' => 'Build LastingPartnerships',
                            'description_2' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_2' => $this->filePath('general/feature-tabs-2.png'),
                            'feature_item_title_1_2' => 'Research planning',
                            'feature_item_description_1_2' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_2' => $this->filePath('icons/icon-14.png'),
                            'feature_item_title_2_2' => 'Investment',
                            'feature_item_description_2_2' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_2' => $this->filePath('icons/icon-2.png'),
                            'tab_name_3' => 'Solicitory Consultancy',
                            'title_3' => 'Enhance Operational',
                            'description_3' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_3' => $this->filePath('general/feature-tabs-3.png'),
                            'feature_item_title_1_3' => 'Research planning',
                            'feature_item_description_1_3' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_3' => $this->filePath('icons/icon-3.png'),
                            'feature_item_title_2_3' => 'Investment',
                            'feature_item_description_2_3' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_3' => $this->filePath('icons/icon-17.png'),
                            'tab_name_4' => 'HR Consultancy',
                            'title_4' => 'Sustainable Growth',
                            'description_4' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_4' => $this->filePath('general/feature-tabs-4.png'),
                            'feature_item_title_1_4' => 'Research planning',
                            'feature_item_description_1_4' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_4' => $this->filePath('icons/icon-12.png'),
                            'feature_item_title_2_4' => 'Investment',
                            'feature_item_description_2_4' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_4' => $this->filePath('icons/icon-18.png'),
                            'tab_name_5' => 'Strategy Consultancy',
                            'title_5' => 'Continuous Evolution',
                            'description_5' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_5' => $this->filePath('general/feature-tabs-5.png'),
                            'feature_item_title_1_5' => 'Research planning',
                            'feature_item_description_1_5' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_5' => $this->filePath('icons/icon-15.png'),
                            'feature_item_title_2_5' => 'Investment',
                            'feature_item_description_2_5' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_5' => $this->filePath('icons/icon-14.png'),
                            'tab_name_6' => 'Start Ups',
                            'title_6' => 'Empower Businesses',
                            'description_6' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image_6' => $this->filePath('general/feature-tabs-6.png'),
                            'feature_item_title_1_6' => 'Research planning',
                            'feature_item_description_1_6' => 'Separating your work from your home life can improve work-life balance.',
                            'feature_item_icon_image_1_6' => $this->filePath('icons/icon-15.png'),
                            'feature_item_title_2_6' => 'Investment',
                            'feature_item_description_2_6' => 'A business consultant provides expert advice and guidance to businesses.',
                            'feature_item_icon_image_2_6' => $this->filePath('icons/icon-12.png'),
                            'background_image' => $this->filePath('backgrounds/team.png'),
                            'primary_action_label' => 'Get a Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-right',
                            'secondary_action_label' => 'Our Help Center',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-phone-call',
                        ],
                    ],
                    [
                        'name' => 'site-statistics',
                        'attributes' => [
                            'style' => '3',
                            'quantity' => '4',
                            'second_tab_title_1' => 'Continuous <br> growth with',
                            'second_tab_description_1' => 'New accounts',
                            'second_tab_data_1' => '24',
                            'second_tab_unit_1' => 'k',
                            'second_tab_title_2' => 'Successfully <br> completed',
                            'second_tab_description_2' => 'Finished projects',
                            'second_tab_data_2' => '1024',
                            'second_tab_title_3' => 'Recruit more <br> than',
                            'second_tab_description_3' => 'Skilled experts',
                            'second_tab_data_3' => '865',
                            'second_tab_title_4' => 'Increase internet <br> awareness',
                            'second_tab_description_4' => 'Media posts',
                            'second_tab_data_4' => '168',
                            'second_tab_unit_4' => 'k',
                        ],
                    ],
                    [
                        'name' => 'blog-posts',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Our Latest Articles',
                            'subtitle' => 'FROM BLOG',
                            'description' => 'Explore the insights and trends shaping our industry',
                            'paginate' => '4',
                            'action_label' => 'See all articles',
                            'action_url' => '/blog',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '1',
                ],
            ],
            [
                'name' => 'Our Team',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'title' => 'Meet Our Team',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => Team::query()->pluck('id')->implode(','),
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '9',
                            'title' => 'We bring a rich variety of <br> experience from multiple fields.',
                            'subtitle' => 'Meet Our Team',
                            'description' => 'Leveraging Extensive Experience: Comprehensive Solutions Crafted from Diverse Professional Backgrounds',
                            'image' => $this->filePath('general/features-9-1.png'),
                            'image_1' => $this->filePath('general/features-9-2.png'),
                        ],
                    ],
                    [
                        'name' => 'call-to-action',
                        'attributes' => [
                            'title' => 'We are <b>Looking to</b> <br> <b>Expand</b> Our Team',
                            'image' => $this->filePath('general/call-to-action-1.png'),
                            'primary_action_label' => 'Explore Now',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Our Team v2',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '5',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => '1,2,3,4,5,6',
                            'quantity' => '1',
                            'title_1' => '+1 (24) 567 890',
                            'subtitle_1' => 'CONTACT US',
                            'url_1' => 'tel:124567890',
                            'icon_image_1' => $this->filePath('icons/contact.png'),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '8',
                            'title' => 'Doing the successful thing, at <br>  the right time.',
                            'subtitle' => 'Recent work',
                            'description' => 'We strive to build long-lasting partnerships with our clients, understanding their unique challenges and opportunities, and providing tailored strategies that lead to measurable success.',
                            'image' => $this->filePath('general/features-8.png'),
                            'floating_card_title' => 'Years of Experience',
                            'floating_card_data_count' => '25',
                            'floating_card_data_count_unit' => '+',
                            'quantity' => '2',
                            'title_1' => 'Research planning',
                            'description_1' => 'Separating your work from your home life can improve work-life balance.',
                            'icon_image_1' => $this->filePath('icons/icon-14.png'),
                            'title_2' => 'Investment',
                            'description_2' => 'A business consultant provides expert advice and guidance to businesses.',
                            'icon_image_2' => $this->filePath('icons/icon-15.png'),
                        ],
                    ],
                    [
                        'name' => 'call-to-action',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'We are <b>Looking to</b> <br> <b>Expand</b> Our Team',
                            'image' => $this->filePath('general/call-to-action-2.png'),
                            'primary_action_label' => 'Explore Now',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Our Team v3',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '6',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day. <br> Company forward every day.',
                            'team_ids' => '1,2,3,4,5,6,7,8',
                            'quantity' => '8',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '3',
                            'title' => '+500k Satisfied Customers',
                            'subtitle' => 'OUR FEATURES',
                            'description' => '🔥 Don’t just take our words',
                            'testimonial_ids' => '1,2,4,5,6,7,8,10,12,14,15',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Our Team v4',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '10',
                            'title' => 'Stay <b>updated</b> with <br> the <b>latest news</b> <br> from <b>our team</b>.',
                            'description' => 'Don\'t miss the trending',
                            'image' => $this->filePath('general/features-10.png'),
                        ],
                    ],
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => '1,2,3,4,5,6,7',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Our Team v5',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Meet <b>everyone</b> who <br> made this <b>possible</b>.',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => '1,2,3,4,5,6,7,8',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Our Team v6',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'bottom_description' => 'Easily Monitor, Control, and Enhance Your Personal and Business Finances. <br> Your All-In-One Solution.',
                            'primary_action_label' => 'Get a Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-narrow-right',
                            'team_ids' => '1,2,3,4,5,6,7,8',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '3',
                            'title' => '+500k Satisfied Customers',
                            'subtitle' => 'OUR FEATURES',
                            'description' => '🔥 Don’t just take our words',
                            'testimonial_ids' => '1,2,4,5,6,7,8,10,12,14,15',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Blog',
                'description' => 'Explore the insights and trends shaping our industry',
                'content' => '',
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Contact',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 1,
                            'quantity' => 4,
                            ...collect([
                                [
                                    'title' => 'Help & Support',
                                    'description' => 'Email support@alithemes.com For \n help with a current product or \n service or refer to FAQs and \n developer tools.',
                                    'icon_image' => $this->filePath('icons/icon-12.png'),
                                ],
                                [
                                    'title' => 'Call Us',
                                    'description' => 'Call us to speak to a member of our \n team. \n (+01) 234 567 89 \n (+01) 456 789 21',
                                    'icon_image' => $this->filePath('icons/icon-13.png'),
                                ],
                                [
                                    'title' => 'Business Department',
                                    'description' => 'Contact the sales department about cooperation projects \n (+01) 789 456 23',
                                    'icon_image' => $this->filePath('icons/icon-14.png'),
                                ],
                                [
                                    'title' => 'Global branch',
                                    'description' => 'Contact us to open our branches \n globally. \n (+01) 234 567 89 \n (+01) 456 789 23',
                                    'icon_image' => $this->filePath('icons/icon-15.png'),
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                        "icon_image_$index" => $feature['icon_image'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'style' => 1,
                            'title' => 'Thinking about a project? Get in touch with us.',
                            'subtitle' => 'Contact Us',
                            'description' => 'Please let us know if you have a question, want to leave \n a comment, or would like further information about \n Infinia Systems.',
                            'background_image' => $this->filePath('backgrounds/contact.png'),
                            'form_title' => 'Get in touch',
                            'form_description' => 'Do you want to know more or contact our sales department?',
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'quantity' => 4,
                            'title_1' => 'Visit the Knowledge Base',
                            'description_1' => 'Browse customer support articles and step-by-step instructions for specific features.',
                            'icon_1' => 'ti ti-search',
                            'title_2' => 'Watch Product Videos',
                            'description_2' => 'Watch our video tutorials for visual walkthroughes on how to use our features.',
                            'icon_2' => 'ti ti-video',
                            'title_3' => 'Visit the Knowledge Base',
                            'description_3' => 'Let us talk about how we can help your enterprise.',
                            'icon_3' => 'ti ti-headphones',
                        ],
                    ],
                    [
                        'name' => 'google-map',
                        'attributes' => [
                            'height' => 650,
                        ],
                        'content' => 'Level 7/180 Flinders St, Melbourne VIC 3000, Australia',
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'About Us',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'about-us-information',
                        'attributes' => [
                            'title' => 'Where your financial dreams become reality',
                            'subtitle' => 'Who we are',
                            'description' => 'Infinia is a digital company specializing in website creation. Enterprises of all sizes—from emerging startups to large corporations—utilize our theme to develop and manage their online presence.',
                            'quantity' => '4',
                            'title_1' => 'Best For IT Consulting',
                            'title_2' => 'Innovative Approaches',
                            'title_3' => 'Save Money & Time',
                            'title_4' => '100% Satisfaction',
                            'image' => $this->filePath('general/about-us-information-img.png'),
                        ],
                    ],
                    [
                        'name' => 'site-statistics',
                        'attributes' => [
                            'title' => 'See why we are <br> trusted the world over',
                            'quantity' => '4',
                            'title_1' => 'New accounts',
                            'data_1' => '496',
                            'unit_1' => 'k',
                            'title_2' => 'Finished projects',
                            'data_2' => '92',
                            'unit_2' => '+',
                            'title_3' => 'Skilled experts',
                            'data_3' => '756',
                            'unit_3' => '+',
                            'title_4' => 'Media posts',
                            'data_4' => '25',
                            'unit_4' => 'k',
                        ],
                    ],
                    [
                        'name' => 'our-mission',
                        'attributes' => [
                            'title' => 'Empowering Your Digital Success Through Innovative Solutions',
                            'subtitle' => 'Our Mission',
                            'description' => 'We believe in building strong relationships with our clients, based on trust, transparency, and mutual success.',
                            'quantity' => '2',
                            'title_1' => 'Transaction <br> Completed',
                            'data_1' => '25',
                            'unit_1' => 'M+',
                            'text_color_1' => 'rgb(0, 0, 0)',
                            'background_color_1' => 'rgb(100, 225, 176)',
                            'title_2' => 'Transaction <br> Completed',
                            'data_2' => '12',
                            'unit_2' => 'k+',
                            'text_color_2' => 'rgb(255, 255, 255)',
                            'background_color_2' => 'rgb(109, 77, 242)',
                            'image' => $this->filePath('general/our-mission-img.png'),
                            'image_1' => $this->filePath('general/our-mission-img-1.png'),
                            'image_2' => $this->filePath('general/our-mission-img-2.png'),
                            'testimonial_limit' => 2,
                        ],
                    ],
                    [
                        'name' => 'our-history',
                        'attributes' => [
                            'title' => 'A Journey of Innovation and Growth',
                            'subtitle' => 'Our History',
                            'description' => 'Loved By Developers Trusted By Enterprises',
                            'main_content' => '<strong>Infinia</strong> was founded with a passion for technology and a desire to make a difference in the digital world. From our humble beginnings, we have grown into a reputable and sought-after web development agency, serving a diverse range of clients across various industries. Over the years, <strong>we have successfully delivered countless projects</strong>, each one a testament to our dedication, expertise, and innovative approach. Our journey has been marked by <strong>continuous growth, learning, and adaptation</strong>, and we are proud of the milestones we have achieved along the way. <br><br> Thank you for considering <strong>Infinia</strong> as your web development partner. We look forward to helping you achieve your <strong>digital goals</strong> and <strong>creating a lasting impact</strong> on your business. ',
                            'author_name' => 'Kensei',
                            'author_title' => 'CEO',
                            'author_signature' => $this->filePath('general/author-signature.png'),
                            'author_avatar' => $this->filePath('general/author-avatar.png'),
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_url' => '/contact',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                        ],
                    ],
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Meet <b>everyone</b> who <br> made this <b>possible</b>.',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => '1,2,3,4,5,6,7,8',
                        ],
                    ],
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'style' => '2',
                            'form_title' => 'Leave a message',
                            'title' => 'Thinking about a project? <br> Get in touch with us.',
                            'subtitle' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'description' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'quantity' => '3',
                            'title_1' => 'Chat with us',
                            'description_1' => 'The support team is always available 24/7',
                            'button_label_1_1' => 'Chat via Whatsapp',
                            'button_url_1_1' => 'https://www.whatsapp.com',
                            'button_icon_1_1' => 'ti ti-brand-whatsapp',
                            'button_label_2_1' => 'Chat via Viber',
                            'button_url_2_1' => 'https://www.viber.com/',
                            'button_icon_2_1' => 'ti ti-phone-call',
                            'button_label_3_1' => 'Chat via Messager',
                            'button_url_3_1' => 'https://www.facebook.com/',
                            'button_icon_3_1' => 'ti ti-brand-messenger',
                            'title_2' => 'Send us an email',
                            'description_2' => 'Our team will respond promptly to your inquiries',
                            'button_label_1_2' => 'support@infinia.com',
                            'button_url_1_2' => 'mailto:support@infinia.com',
                            'button_icon_1_2' => 'ti ti-mail',
                            'button_label_2_2' => 'sale@infinia.com',
                            'button_url_2_2' => 'mailto:sale@infinia.com',
                            'button_icon_2_2' => 'ti ti-mail',
                            'title_3' => 'For more inquiry',
                            'description_3' => 'Reach out for immediate assistance',
                            'button_label_1_3' => '+01 (24) 568 900',
                            'button_url_1_3' => 'tell:0124568900',
                            'button_icon_1_3' => 'ti ti-phone-call',
                            'background_color' => '#fff7ee',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '3',
                            'title' => '+500k Satisfied Customers',
                            'subtitle' => 'OUR FEATURES',
                            'description' => '🔥 Don’t just take our words',
                            'testimonial_ids' => '1,2,4,5,6,7,8,10,12,14,15',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'information-block',
                        'attributes' => [
                            'image' => $this->filePath('icons/icon-star.png'),
                            'title' => 'Core values',
                            'description' => 'We break down barriers so teams can focus on what matters – working together to create products their customers love.',
                            'quantity' => '8',
                            'title_1' => 'Genuine repeated <br> happy customers.',
                            'data_1' => '98',
                            'unit_1' => '%',
                            'title_2' => 'Genuine repeated <br> happy customers.',
                            'data_2' => '98',
                            'unit_2' => '%',
                            'title_3' => 'Customers First',
                            'icon_image_3' => $this->filePath('icons/check.png'),
                            'description_3' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'title_4' => 'Think Big',
                            'icon_image_4' => $this->filePath('icons/check.png'),
                            'description_4' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'title_5' => 'Make a Difference',
                            'icon_image_5' => $this->filePath('icons/check.png'),
                            'description_5' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'title_6' => 'Act With Integrity',
                            'icon_image_6' => $this->filePath('icons/check.png'),
                            'description_6' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'title_7' => 'Do the right thing',
                            'icon_image_7' => $this->filePath('icons/check.png'),
                            'description_7' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'title_8' => 'Stronger united',
                            'icon_image_8' => $this->filePath('icons/check.png'),
                            'description_8' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'description_9' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'description_10' => 'Our company exists to help merchants sell more. We make every decision and measure every outcome based on how well it serves our customers.',
                            'background_color' => '#a38cff',
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'About Us v2',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'our-mission',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Uncover Our <b> Journey: </b> <br> Uniting Through <b> Creativity </b>',
                            'subtitle' => 'About our company',
                            'description' => 'Our dedication to quality and excellence has made us a trusted partner for enterprises looking to enhance their online presence.',
                            'quantity' => '4',
                            'title_1' => 'Projects Completed',
                            'data_1' => '23',
                            'unit_1' => 'k+',
                            'title_2' => 'Users Activated',
                            'data_2' => '38',
                            'unit_2' => 'k+',
                            'title_3' => 'Happy Clients',
                            'data_3' => '98k+',
                            'text_color_3' => 'transparent',
                            'background_color_3' => 'transparent',
                            'title_4' => 'Operating countries',
                            'data_4' => '150',
                            'testimonial_box_title' => 'Loved by over 4k <br> happy clients',
                            'testimonial_limit' => '5',
                            'image' => $this->filePath('general/our-mission-img-2-1.png'),
                            'image_1' => $this->filePath('general/our-mission-img-2-2.png'),
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'partners',
                        'attributes' => [
                            'style' => 3,
                            'title' => 'Trusted by great companies',
                            'quantity' => 20,
                            ...collect(['Framer', 'Reddit', 'Netflix', 'Microsoft', 'Discover', 'Lemon Squeezy', 'Paypal', 'Youtube', 'Spotify', 'Google', 'Amazon', 'Apple', 'Facebook', 'Twitter', 'Instagram', 'Slack', 'Tiktok', 'Pinterest', 'Medium', 'Linkedin'])
                                ->mapWithKeys(function ($name, $index) {
                                    $index++;

                                    $imageName = $index > 8 ? rand(1, 8) : $index;

                                    return [
                                        "name_$index" => $name,
                                        "image_$index" => $this->filePath("partners/$imageName.png"),
                                        "url_$index" => 'https://google.com',
                                        "open_in_new_tab_$index" => true,
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'bottom_description' => 'Easily Monitor, Control, and Enhance Your Personal and Business Finances. <br> Your All-In-One Solution.',
                            'primary_action_label' => 'Get a Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-narrow-right',
                            'team_ids' => '1,2,3,4,5,6,7,8',
                        ],
                    ],
                    [
                        'name' => 'services',
                        'attributes' => [
                            'style' => '2',
                            'service_ids' => '1,3,4,5',
                            'background_color' => '#a38cff',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Optimize Your <br> Finances with Ease.',
                            'subtitle' => 'OUR FEATURES',
                            'image' => $this->filePath('general/features-4-1.png'),
                            'image_1' => $this->filePath('general/features-4-2.png'),
                            'quantity' => '3',
                            'title_1' => 'Our History',
                            'description_1' => 'A Journey of Innovation, Growth, and Technological Advancement',
                            'icon_image_1' => $this->filePath('icons/icon-1.png'),
                            'title_2' => 'Our Mission',
                            'description_2' => 'Empowering Your Digital Success Through Innovative Solutions',
                            'icon_image_2' => $this->filePath('icons/icon-2.png'),
                            'title_3' => 'Our Vision',
                            'description_3' => 'Leading the Future of Web Development with Excellence and Innovation',
                            'icon_image_3' => $this->filePath('icons/icon-3.png'),
                        ],
                    ],
                    [
                        'name' => 'projects',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Recent work',
                            'subtitle' => 'Our feared projects',
                            'description' => '⚡Don\'t miss any contact. Stay connected.',
                            'project_ids' => '1,3,4,6',
                            'limit' => '4',
                        ],
                    ],
                    [
                        'name' => 'blog-posts',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Reach out to <br> the world\'s most',
                            'subtitle' => 'Why us ?',
                            'description' => '⚡Here are a few reasons why our customers choose Infinia.',
                            'paginate' => '8',
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'About Us v3',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'about-us-information',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Together, We are <b>Shaping</b> a <br> <b>Promising</b> Future.',
                            'subtitle' => 'About us',
                            'quantity' => '6',
                            'image' => $this->filePath('general/about-us-information-2-1.jpeg'),
                            'display_social_links' => '0,1',
                            'social_links_box_title' => 'Follow Us:',
                        ],
                    ],
                    [
                        'name' => 'services',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Our Core Values',
                            'description' => 'We break down barriers so teams can focus on what matters – working together <br> to create products their customers love.',
                            'service_ids' => '1,2,3,4',
                        ],
                    ],
                    [
                        'name' => 'teams',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Meet Our Team',
                            'subtitle' => 'OUR TEAM MEMBERS',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'team_ids' => '1,2,3,4,5,6,7',
                        ],
                    ],
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'style' => '2',
                            'form_title' => 'Leave a message',
                            'title' => 'Thinking about a project? <br> Get in touch with us.',
                            'subtitle' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'description' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'quantity' => '3',
                            'title_1' => 'Chat with us',
                            'description_1' => 'The support team is always available 24/7',
                            'button_label_1_1' => 'Chat via Whatsapp',
                            'button_url_1_1' => 'https://www.whatsapp.com',
                            'button_icon_1_1' => 'ti ti-brand-whatsapp',
                            'button_label_2_1' => 'Chat via Viber',
                            'button_url_2_1' => 'https://www.viber.com/',
                            'button_icon_2_1' => 'ti ti-phone-call',
                            'button_label_3_1' => 'Chat via Messager',
                            'button_url_3_1' => 'https://www.facebook.com/',
                            'button_icon_3_1' => 'ti ti-brand-messenger',
                            'title_2' => 'Send us an email',
                            'description_2' => 'Our team will respond promptly to your inquiries',
                            'button_label_1_2' => 'support@infinia.com',
                            'button_url_1_2' => 'mailto:support@infinia.com',
                            'button_icon_1_2' => 'ti ti-mail',
                            'button_label_2_2' => 'sale@infinia.com',
                            'button_url_2_2' => 'mailto:sale@infinia.com',
                            'button_icon_2_2' => 'ti ti-mail',
                            'title_3' => 'For more inquiry',
                            'description_3' => 'Reach out for immediate assistance',
                            'button_label_1_3' => '+01 (24) 568 900',
                            'button_url_1_3' => 'tell:0124568900',
                            'button_icon_1_3' => 'ti ti-phone-call',
                            'background_color' => '#ffffff',
                        ],
                    ],
                    [
                        'name' => 'blog-posts',
                        'attributes' => [
                            'subtitle' => 'FROM BLOG',
                            'title' => 'Our Latest Articles',
                            'description' => 'Explore the insights and trends shaping our industry',
                            'paginate' => 3,
                            'action_label' => 'View All Articles',
                            'action_url' => '/blog',
                        ],
                    ],
                ]) . '<br/><br/>' ,
                'template' => 'full-width',
            ],
            [
                'name' => 'Pricing',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'style' => '3',
                            'title' => '<b>Straightforward</b>  Pricing <br> Custom <b>Integrations</b>',
                            'subtitle' => 'Our Pricing',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'quantity' => '6',
                            'package_ids' => '1,2,3',
                            'background_images' => $this->filePath('backgrounds/bg-line-bottom.png'),
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-narrow-right',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                        ],
                    ],
                    [
                        'name' => 'compare-plans',
                        'attributes' => [
                            'title' => 'Compare Features',
                            'subtitle' => 'Compare Plans',
                            'description' => 'A management platform to help you succeed',
                            'package_name_1' => 'Starter',
                            'package_description_1' => 'from $19/month',
                            'package_name_2' => 'Standard',
                            'package_description_2' => 'from $49/month',
                            'package_name_3' => 'Enterprise',
                            'package_description_3' => 'from $99/month',
                            'quantity' => '10',
                            'criteria_1' => 'Docs/month',
                            'description_1' => 'Monthly Documentation Capacity',
                            'value_1_1' => 'yes',
                            'value_2_1' => 'yes',
                            'value_3_1' => 'yes',
                            'criteria_2' => 'Integration',
                            'description_2' => 'Seamless System Integration',
                            'value_1_2' => 'yes',
                            'value_2_2' => 'yes',
                            'value_3_2' => 'yes',
                            'criteria_3' => 'Workspaces',
                            'description_3' => 'Organized Work Environments',
                            'value_1_3' => 'yes',
                            'value_2_3' => 'yes',
                            'value_3_3' => 'yes',
                            'criteria_4' => 'Collaborators',
                            'description_4' => 'Team Collaboration Features',
                            'value_1_4' => 'no',
                            'value_2_4' => 'yes',
                            'value_3_4' => 'yes',
                            'criteria_5' => 'Real-time collaboration',
                            'description_5' => 'Instant Collaborative Editing',
                            'value_1_5' => 'no',
                            'value_2_5' => 'yes',
                            'value_3_5' => 'yes',
                            'criteria_6' => 'File uploads',
                            'description_6' => 'Effortless File Management',
                            'value_1_6' => 'yes',
                            'value_2_6' => 'yes',
                            'value_3_6' => 'yes',
                            'criteria_7' => 'Transcripts',
                            'description_7' => 'Accurate Meeting Transcripts',
                            'value_1_7' => '2h / month',
                            'value_2_7' => 'Unlimited',
                            'value_3_7' => 'Unlimited',
                            'criteria_8' => 'Image uploads',
                            'description_8' => 'Simple Image Storage',
                            'value_1_8' => 'Up to 5 MB per file',
                            'value_2_8' => 'Unlimited',
                            'value_3_8' => 'Unlimited',
                            'criteria_9' => 'Email Campaigns',
                            'description_9' => 'Effective Email Marketing ',
                            'value_1_9' => '03 Campaigns',
                            'value_2_9' => 'Unlimited',
                            'value_3_9' => 'Unlimited',
                            'criteria_10' => 'Custom Branding',
                            'description_10' => 'Personalized Brand Experience',
                            'value_1_10' => '01 Workspaces',
                            'value_2_10' => '05 Workspaces',
                            'value_3_10' => 'Unlimited',
                            'bottom_description' => 'We also offer other customized services to fit your business.',
                            'primary_action_label' => 'Get a Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-right',
                            'secondary_action_label' => 'Our Help Center',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-phone-call',
                        ],
                    ],
                    [
                        'name' => 'instruction-steps',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'How It Works',
                            'subtitle' => 'working process',
                            'description' => 'Comprehensive Suite of Cutting-Edge IT Services.',
                            'quantity' => '3',
                            'title_1' => 'Choose Services',
                            'description_1' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_1' => $this->filePath('icons/icon-16.png'),
                            'title_2' => 'Project Analysis',
                            'description_2' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_2' => $this->filePath('icons/icon-14.png'),
                            'title_3' => 'Got Final Result',
                            'description_3' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_3' => $this->filePath('icons/icon-15.png'),
                            'bottom_description' => 'Need more help? Go to our',
                            'action_label' => 'Support Center',
                            'action_url' => '/contact',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'faqs',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Frequently Asked  <br> Questions',
                            'description' => 'Find the answers to all of our most frequently asked questions',
                            'image' => $this->filePath('general/faqs-img-2.png'),
                            'quantity' => '3',
                            'title_1' => 'Live chat support 24/7',
                            'description_1' => 'More than 300 employees are ready to help you',
                            'icon_image_1' => $this->filePath('icons/icon-1.png'),
                            'title_2' => 'Help desk support center',
                            'description_2' => 'Via ticket system. 24/7 available.',
                            'icon_image_2' => $this->filePath('icons/icon-2.png'),
                            'title_3' => 'Book a demo',
                            'description_3' => 'Live support via video call',
                            'icon_image_3' => $this->filePath('icons/icon-15.png'),
                            'category_ids' => '1,2,3',
                            'background_image' => $this->filePath('backgrounds/faqs.png'),
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'What <b> People Say </b> About <br> <b>Our Company</b>',
                            'subtitle' => 'TESTIMONIALS',
                            'description' => 'Access top-tier group mentoring plans and exclusive professional <br> benefits for your team. 🔥',
                            'testimonial_ids' => '1,2,3,4,5',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'Pricing v2',
                'content' => '<br><br><br>' . $this->generateShortcodeContent([
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'subtitle' => 'OUR PLANS',
                            'title' => 'Pricing Plans',
                            'description' => '⚡We’ve got a pricing plan that’s perfect for you',
                            'package_ids' => Package::query()->pluck('id')->implode(','),
                        ],
                    ],
                    [
                        'name' => 'compare-plans',
                        'attributes' => [
                            'title' => 'Compare Features',
                            'subtitle' => 'Compare Plans',
                            'description' => 'A management platform to help you succeed',
                            'package_name_1' => 'Starter',
                            'package_description_1' => 'from $19/month',
                            'package_name_2' => 'Standard',
                            'package_description_2' => 'from $49/month',
                            'package_name_3' => 'Enterprise',
                            'package_description_3' => 'from $99/month',
                            'quantity' => '10',
                            'criteria_1' => 'Docs/month',
                            'description_1' => 'Monthly Documentation Capacity',
                            'value_1_1' => 'yes',
                            'value_2_1' => 'yes',
                            'value_3_1' => 'yes',
                            'criteria_2' => 'Integration',
                            'description_2' => 'Seamless System Integration',
                            'value_1_2' => 'yes',
                            'value_2_2' => 'yes',
                            'value_3_2' => 'yes',
                            'criteria_3' => 'Workspaces',
                            'description_3' => 'Organized Work Environments',
                            'value_1_3' => 'yes',
                            'value_2_3' => 'yes',
                            'value_3_3' => 'yes',
                            'criteria_4' => 'Collaborators',
                            'description_4' => 'Team Collaboration Features',
                            'value_1_4' => 'no',
                            'value_2_4' => 'yes',
                            'value_3_4' => 'yes',
                            'criteria_5' => 'Real-time collaboration',
                            'description_5' => 'Instant Collaborative Editing',
                            'value_1_5' => 'no',
                            'value_2_5' => 'yes',
                            'value_3_5' => 'yes',
                            'criteria_6' => 'File uploads',
                            'description_6' => 'Effortless File Management',
                            'value_1_6' => 'yes',
                            'value_2_6' => 'yes',
                            'value_3_6' => 'yes',
                            'criteria_7' => 'Transcripts',
                            'description_7' => 'Accurate Meeting Transcripts',
                            'value_1_7' => '2h / month',
                            'value_2_7' => 'Unlimited',
                            'value_3_7' => 'Unlimited',
                            'criteria_8' => 'Image uploads',
                            'description_8' => 'Simple Image Storage',
                            'value_1_8' => 'Up to 5 MB per file',
                            'value_2_8' => 'Unlimited',
                            'value_3_8' => 'Unlimited',
                            'criteria_9' => 'Email Campaigns',
                            'description_9' => 'Effective Email Marketing ',
                            'value_1_9' => '03 Campaigns',
                            'value_2_9' => 'Unlimited',
                            'value_3_9' => 'Unlimited',
                            'criteria_10' => 'Custom Branding',
                            'description_10' => 'Personalized Brand Experience',
                            'value_1_10' => '01 Workspaces',
                            'value_2_10' => '05 Workspaces',
                            'value_3_10' => 'Unlimited',
                            'bottom_description' => 'We also offer other customized services to fit your business.',
                            'primary_action_label' => 'Get a Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-right',
                            'secondary_action_label' => 'Our Help Center',
                            'secondary_action_url' => '/contact',
                            'secondary_action_icon' => 'ti ti-phone-call',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '2',
                            'title' => '<b> +100k users </b> have loved <br> <b> Infinia Conference </b> System',
                            'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                            'testimonial_ids' => '1,2,3,4,5,6',
                            'primary_action_label' => 'View More Testimonials',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'primary_action_url' => '/about-us',
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'Pricing v3',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Pick Your Premium',
                            'subtitle' => 'OUR PLANS',
                            'description' => 'Upgrade to Spotify Premium and take your music journey to the next level. Enjoy uninterrupted music playback, even in offline mode',
                            'features' => 'Get 30 day free trial \n You can cancel anytime \n No any hidden fees pay \n Monthly management',
                            'bottom_title' => 'Trusted by secure payment service',
                            'quantity' => '4',
                            'name_1' => 'PayPal',
                            'url_1' => 'https://www.paypal.com/',
                            'image_1' => $this->filePath('general/paypal.png'),
                            'name_2' => 'Stripe',
                            'url_2' => 'https://www.stripe.com/',
                            'image_2' => $this->filePath('general/stripe.png'),
                            'name_3' => 'Mastercard',
                            'url_3' => 'https://www.mastercard.us/en-us.html',
                            'image_3' => $this->filePath('general/mastercard.png'),
                            'name_4' => 'Skrill',
                            'url_4' => 'https://www.skrill.com/',
                            'image_4' => $this->filePath('general/skrill.png'),
                            'package_ids' => '1,2',
                        ],
                    ],
                    [
                        'name' => 'faqs',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Ask us anything',
                            'subtitle' => 'Pricing FAQs',
                            'description' => 'Have any questions? We\'re here to assist you.',
                            'quantity' => '6',
                            'category_ids' => '1,2,3',
                            'limit' => '10',
                        ],
                    ],
                    [
                        'name' => 'faqs',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Got questions? <br> We\'ve got answers',
                            'subtitle' => 'Frequently Asked questions',
                            'description' => 'Quick answers to questions you may have. Can\'t find what you\'re looking for? Get in touch with us. ',
                            'image' => $this->filePath('general/faqs-4-1.png'),
                            'image_1' => $this->filePath('general/faqs-4-2.png'),
                            'category_ids' => '1,2,3',
                            'limit' => '5',
                            'primary_action_label' => 'Get in touch',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'secondary_action_label' => 'Help Center',
                            'secondary_action_url' => '/contact',
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '3',
                            'title' => '+500k Satisfied Customers',
                            'subtitle' => 'OUR FEATURES',
                            'description' => '🔥 Don’t just take our words',
                            'testimonial_ids' => '1,2,4,5,6,7,8,10,12,14,15',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'Coming Soon',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'newsletter',
                        'attributes' => [
                            'title' => 'Get Notified <br> When We Launch',
                            'subtitle' => 'Under Construction',
                            'description' => 'Our design projects are fresh and simple and will benefit your business greatly. Learn more about our work!',
                            'button_label' => 'Join now',
                            'image' => $this->filePath('general/app-downloads-img.png'),
                        ],
                    ],
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'Features',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 1,
                            'title' => 'Together, we are creating a <span>Bright Future</span>',
                            'subtitle' => 'OUR FEATURES',
                            'image' => $this->filePath('backgrounds/feature.png'),
                            'quantity' => 4,
                            ...collect([
                                [
                                    'title' => 'Work organization',
                                    'description' => 'A business consultant provides expert advice and guidance to businesses on various aspects.',
                                    'icon_image' => $this->filePath('icons/icon-1.png'),
                                ],
                                [
                                    'title' => 'Strategy Development',
                                    'description' => 'Business consultants play a crucial role by offering expert advice and guidance to companies',
                                    'icon_image' => $this->filePath('icons/icon-2.png'),
                                ],
                                [
                                    'title' => 'Data analytics',
                                    'description' => 'Consultants provide invaluable expertise to businesses, assisting them with strategic advice',
                                    'icon_image' => $this->filePath('icons/icon-3.png'),
                                ],
                                [
                                    'title' => 'Business Intelligence',
                                    'description' => 'Through their deep understanding of industry trends and best practices, consultants empower organizations',
                                    'icon_image' => $this->filePath('icons/icon-4.png'),
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                        "icon_image_$index" => $feature['icon_image'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 3,
                            'title' => 'Powerful agency for corporate business.',
                            'subtitle' => 'Company\'s vision',
                            'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                            'image' => $this->filePath('backgrounds/feature-3.png'),
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                            'floating_card_image' => $this->filePath('shapes/testimonial-star.png'),
                            'floating_card_title' => 'Rate For Us',
                            'floating_card_description' => 'Loved by over 4k \n happy clients',
                            'quantity' => 2,
                            ...collect([
                                [
                                    'title' => '99%',
                                    'description' => 'Genuine repeated happy customers.',
                                ],
                                [
                                    'title' => '98%',
                                    'description' => 'Trusted by companies.',
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'projects',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Proud projects <b>that make</b> <br> <b>us stand</b> out',
                            'subtitle' => 'Why We Are The Best',
                            'description' => 'Nunc bibendum augue sed mattis porta. Donec pharetra magna tortor, quis bibendum ligula faucibus vitae,',
                            'data_count' => '50',
                            'data_count_unit' => 'k',
                            'project_ids' => '1,2,3',
                            'quantity' => '4',
                            'title_1' => 'Offshore Software Development',
                            'description_1' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                            'title_2' => 'Custom Software Development',
                            'description_2' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                            'title_3' => 'Software Outsourcing Services',
                            'description_3' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                            'title_4' => 'Software Product Development',
                            'description_4' => 'Getting started is simple! Download the app from the App Store or Google Play Store, create an account using your email or social media login, and start making video calls instantly.',
                        ],
                    ],
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'style' => '2',
                            'form_title' => 'Leave a message',
                            'title' => 'Thinking about a project? <br> Get in touch with us.',
                            'subtitle' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'description' => 'Connect with Us Today through the Details Below or Fill Out the Form for a Prompt Response',
                            'quantity' => '3',
                            'title_1' => 'Chat with us',
                            'description_1' => 'The support team is always available 24/7',
                            'button_label_1_1' => 'Chat via Whatsapp',
                            'button_url_1_1' => 'https://www.whatsapp.com',
                            'button_icon_1_1' => 'ti ti-brand-whatsapp',
                            'button_label_2_1' => 'Chat via Viber',
                            'button_url_2_1' => 'https://www.viber.com/',
                            'button_icon_2_1' => 'ti ti-phone-call',
                            'button_label_3_1' => 'Chat via Messager',
                            'button_url_3_1' => 'https://www.facebook.com/',
                            'button_icon_3_1' => 'ti ti-brand-messenger',
                            'title_2' => 'Send us an email',
                            'description_2' => 'Our team will respond promptly to your inquiries',
                            'button_label_1_2' => 'support@infinia.com',
                            'button_url_1_2' => 'mailto:support@infinia.com',
                            'button_icon_1_2' => 'ti ti-mail',
                            'button_label_2_2' => 'sale@infinia.com',
                            'button_url_2_2' => 'mailto:sale@infinia.com',
                            'button_icon_2_2' => 'ti ti-mail',
                            'title_3' => 'For more inquiry',
                            'description_3' => 'Reach out for immediate assistance',
                            'button_label_1_3' => '+01 (24) 568 900',
                            'button_url_1_3' => 'tell:0124568900',
                            'button_icon_1_3' => 'ti ti-phone-call',
                            'background_color' => '#ffffff',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Features v2',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Optimize Your <br> Finances with Ease.',
                            'subtitle' => 'OUR FEATURES',
                            'image' => $this->filePath('general/features-4-1.png'),
                            'image_1' => $this->filePath('general/features-4-2.png'),
                            'quantity' => '3',
                            'title_1' => 'Our History',
                            'description_1' => 'A Journey of Innovation, Growth, and Technological Advancement',
                            'icon_image_1' => $this->filePath('icons/icon-1.png'),
                            'title_2' => 'Our Mission',
                            'description_2' => 'Empowering Your Digital Success Through Innovative Solutions',
                            'icon_image_2' => $this->filePath('icons/icon-2.png'),
                            'title_3' => 'Our Vision',
                            'description_3' => 'Leading the Future of Web Development with Excellence and Innovation',
                            'icon_image_3' => $this->filePath('icons/icon-3.png'),
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => '9',
                            'title' => 'We bring a rich variety of <br> experience from multiple fields.',
                            'subtitle' => 'Meet Our Team',
                            'description' => 'Leveraging Extensive Experience: Comprehensive Solutions Crafted from Diverse Professional Backgrounds',
                            'image' => $this->filePath('general/features-9-1.png'),
                            'image_1' => $this->filePath('general/features-9-2.png'),
                        ],
                    ],
                    [
                        'name' => 'faqs',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'Frequently Asked  <br> Questions',
                            'description' => 'Find the answers to all of our most frequently asked questions',
                            'image' => $this->filePath('general/faqs-img-2.png'),
                            'quantity' => '3',
                            'title_1' => 'Live chat support 24/7',
                            'description_1' => 'More than 300 employees are ready to help you',
                            'icon_image_1' => $this->filePath('icons/icon-1.png'),
                            'title_2' => 'Help desk support center',
                            'description_2' => 'Via ticket system. 24/7 available.',
                            'icon_image_2' => $this->filePath('icons/icon-2.png'),
                            'title_3' => 'Book a demo',
                            'description_3' => 'Live support via video call',
                            'icon_image_3' => $this->filePath('icons/icon-15.png'),
                            'category_ids' => '1,2,3',
                            'background_image' => $this->filePath('backgrounds/faqs.png'),
                        ],
                    ],
                    [
                        'name' => 'services',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'Professional <b>UltraHD Video</b> <br> <b>Conferencing</b> Platform',
                            'subtitle' => 'WHAT WE OFFERS',
                            'service_ids' => '1,3,4,6',
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'primary_action_url' => '/contact',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                        ],
                    ],
                    [
                        'name' => 'features',
                        'attributes' => [
                            'style' => 2,
                            'title' => 'Scalable Business for <span>Startups</span>',
                            'subtitle' => 'OUR FEATURES',
                            'checklist' => 'Success Accelerators\nStarted politician Club\nBusiness Intelligence\nData analytics',
                            'image' => $this->filePath('shapes/img-favicon.png'),
                            'floating_card_image' => $this->filePath('backgrounds/feature-2.png'),
                            'floating_card_title' => 'Transform Your Business \n Into Profession',
                            'floating_card_description' => 'Achieve Your a of Business',
                            'floating_card_button_label' => 'Free Update',
                            'floating_card_button_url' => '/contact',
                            'quantity' => 2,
                            ...collect([
                                [
                                    'title' => 'Efficiency Experts',
                                    'description' => 'A business consultant provides expert advice and guidance to businesses on various aspects.',
                                    'icon_image' => $this->filePath('icons/icon-5.png'),
                                ],
                                [
                                    'title' => 'Strategic Solutions',
                                    'description' => 'Discover why hundreds of millions people use Infinia to chat and call every day.',
                                    'icon_image' => null,
                                ],
                            ])
                                ->mapWithKeys(function ($feature, $index) {
                                    $index++;

                                    return [
                                        "title_$index" => $feature['title'],
                                        "description_$index" => $feature['description'],
                                        "icon_image_$index" => $feature['icon_image'],
                                    ];
                                })
                                ->all(),
                        ],
                    ],
                    [
                        'name' => 'services',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Our Core Values',
                            'description' => 'We break down barriers so teams can focus on what matters – working together <br> to create products their customers love.',
                            'service_ids' => '1,2,3,4',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Privacy Policy',
                'content' =>
                    '<br><br>' .
                    Shortcode::generateShortcode('content-page', [
                        'title' => 'Infinia System Privacy Policy',
                        'subtitle' => 'Privacy Policy',
                        'description' => 'At Infinia System, we value your privacy and are committed to protecting your personal information. This Privacy Policy outlines how we collect, use, disclose, and safeguard your data when you use our services.',
                    ]) .
                    file_get_contents(database_path('seeders/contents/term-and-privacy.html')) .
                    Shortcode::generateShortcode('content-page', [
                        'contact_section_title' => 'Contact Us',
                        'contact_section_description' => 'If you have any questions or concerns about this Privacy Policy, please contact us at:',
                        'contact_section_subtitle' => 'Chat with us',
                        'contact_section_sub_description' => 'The support team is always available 24/7',
                        'quantity' => '5',
                        'action_label_1' => 'Chat via Whatsapp',
                        'action_url_1' => 'https://www.whatsapp.com/',
                        'action_icon_1' => 'ti ti-brand-whatsapp',
                        'action_label_2' => 'Chat via Viber',
                        'action_url_2' => 'https://www.viber.com/',
                        'action_icon_2' => 'ti ti-phone-call',
                        'action_label_3' => 'Chat via Messager',
                        'action_url_3' => 'https://www.facebook.com/',
                        'action_icon_3' => 'ti ti-brand-messenger',
                        'action_label_4' => 'support@infinia.com',
                        'action_url_4' => 'mailto:support@infinia.com',
                        'action_icon_4' => 'ti ti-mail',
                        'action_label_5' => 'Send us an email',
                        'action_url_5' => 'mailto:sale@infinia.com',
                        'action_icon_5' => 'ti ti-mail',
                ]) . '<br><br>',
            ],
            [
                'name' => 'Work Process',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'our-history',
                        'attributes' => [
                            'style' => '4',
                            'title' => 'What are the <b>Steps Involved</b> in <br> Our <b>Process</b>?',
                            'subtitle' => 'How It Work',
                            'image' => $this->filePath('general/our-history-4.png'),
                            'floating_action_label' => 'Video Guide',
                            'floating_action_url' => 'https://www.youtube.com/watch?v=tRxGSHL8bI0',
                            'floating_action_icon' => 'ti ti-brand-youtube',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'work-process',
                        'attributes' => [
                            'style' => '1',
                            'no' => '01',
                            'title' => 'Choose Services. <br> Initial Consultation.',
                            'description' => '⚡Begin by exploring the range of services we offer.',
                            'image' => $this->filePath('general/work-process-1.png'),
                            'quantity' => '4',
                            'title_1' => 'Explore our services. Personalized planning',
                            'title_2' => 'Assess your needs and goals.',
                            'title_3' => 'Select services that align with your objectives.',
                            'title_4' => 'Begin your journey with us by choosing the right services.',
                            'background_color' => 'rgb(242, 251, 249)',
                        ],
                    ],
                    [
                        'name' => 'work-process',
                        'attributes' => [
                            'style' => '2',
                            'no' => '02',
                            'title' => 'Research & Strategy',
                            'description' => 'We analyze market trends, evaluate your financial situation',
                            'image' => $this->filePath('general/work-process-2.png'),
                            'quantity' => '4',
                            'title_1' => 'Conduct thorough research on market trends',
                            'title_2' => 'Valuate your current financial status and resources',
                            'title_3' => 'Develop a customized strategy tailored',
                            'title_4' => 'Outline clear steps and milestones',
                        ],
                    ],
                    [
                        'name' => 'work-process',
                        'attributes' => [
                            'style' => '1',
                            'no' => '03',
                            'title' => 'Implementation Plan',
                            'description' => 'We analyze market trends, evaluate your financial situation',
                            'image' => $this->filePath('general/work-process-3.png'),
                            'quantity' => '4',
                            'title_1' => 'Create a detailed action plan',
                            'title_2' => 'Assign responsibilities and roles for each phase',
                            'title_3' => 'Set realistic timelines and benchmarks for progress',
                            'title_4' => 'Ensure the plan aligns with your financial strategy',
                        ],
                    ],
                    [
                        'name' => 'work-process',
                        'attributes' => [
                            'style' => '2',
                            'no' => '04',
                            'title' => 'Final Results',
                            'description' => 'We analyze market trends, evaluate your financial situation',
                            'image' => $this->filePath('general/work-process-4.png'),
                            'quantity' => '4',
                            'title_1' => 'Implement the strategy and monitor progress.',
                            'title_2' => 'Receive updates on achieved outcomes.',
                            'title_3' => 'Ensure results meet your financial goals.',
                            'title_4' => 'Set a path to financial success.',
                        ],
                    ],
                    [
                        'name' => 'contact-block',
                        'attributes' => [
                            'title' => 'Providing the <br> Ultimate Experience <br> in Financial Services',
                            'contact_icon' => 'icons/contact.png',
                            'contact_title' => 'Contact Us',
                            'contact_label' => '+01 (24) 568 900',
                            'contact_url' => 'tel:0124568 900',
                            'primary_action_label' => 'Get 15 Days Free Trial',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-narrow-right',
                            'background_image' => $this->filePath('general/contact-block.png'),
                        ],
                    ],
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'subtitle' => 'OUR PLANS',
                            'title' => 'Pricing Plans',
                            'description' => '⚡We’ve got a pricing plan that’s perfect for you',
                            'package_ids' => Package::query()->pluck('id')->implode(','),
                        ],
                    ],
                    [
                        'name' => 'faqs',
                        'attributes' => [
                            'style' => '3',
                            'title' => 'Ask us anything',
                            'subtitle' => 'Pricing FAQs',
                            'description' => 'Have any questions? We\'re here to assist you.',
                            'quantity' => '6',
                            'category_ids' => '1,2,3',
                            'limit' => '10',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Page Integration',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'support-tools',
                        'attributes' => [
                            'title' => 'Access and integrate with 150+ of your preferred tools',
                            'subtitle' => 'WORKING PROCESS',
                            'quantity' => '9',
                            'name_1' => 'Framer',
                            'logo_1' => $this->filePath('partners/icon-1.png'),
                            'description_1' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_1' => 'Install now',
                            'action_url_1' => 'https://www.framer.com/',
                            'name_2' => 'Reddit',
                            'logo_2' => $this->filePath('partners/icon-2.png'),
                            'description_2' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_2' => 'Install now',
                            'action_url_2' => 'https://www.reddit.com/',
                            'name_3' => 'Airbnb',
                            'logo_3' => $this->filePath('partners/icon-3.png'),
                            'description_3' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_3' => 'Install now',
                            'action_url_3' => 'https://airbnb.com',
                            'name_4' => 'Lemon Squeezy',
                            'logo_4' => $this->filePath('partners/icon-4.png'),
                            'description_4' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_4' => 'Install now',
                            'action_url_4' => 'https://www.lemonsqueezy.com/',
                            'name_5' => 'Netflix',
                            'logo_5' => $this->filePath('partners/icon-5.png'),
                            'description_5' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_5' => 'Install now',
                            'action_url_5' => 'https://www.netflix.com/',
                            'name_6' => 'Instagram',
                            'logo_6' => $this->filePath('partners/icon-8.png'),
                            'description_6' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_6' => 'Install now',
                            'action_url_6' => 'https://www.instagram.com/',
                            'name_7' => 'Mailchimp',
                            'logo_7' => $this->filePath('partners/icon-6.png'),
                            'description_7' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_7' => 'Install now',
                            'action_url_7' => 'https://mailchimp.com/',
                            'name_8' => 'Paypal',
                            'logo_8' => $this->filePath('partners/icon-9.png'),
                            'description_8' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_8' => 'Install now',
                            'action_url_8' => 'https://www.paypal.com/',
                            'name_9' => 'Example',
                            'logo_9' => $this->filePath('partners/icon-7.png'),
                            'description_9' => 'Separating your work from your home life can improve work-life balance and coworking spaces provide a dedicated place to work',
                            'action_label_9' => 'Install now',
                            'action_url_9' => 'https://google.com',
                        ],
                    ],
                    [
                        'name' => 'instruction-steps',
                        'attributes' => [
                            'style' => '2',
                            'title' => 'How It Works',
                            'subtitle' => 'working process',
                            'description' => 'Comprehensive Suite of Cutting-Edge IT Services.',
                            'quantity' => '3',
                            'title_1' => 'Choose Services',
                            'description_1' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_1' => $this->filePath('icons/icon-16.png'),
                            'title_2' => 'Project Analysis',
                            'description_2' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_2' => $this->filePath('icons/icon-14.png'),
                            'title_3' => 'Got Final Result',
                            'description_3' => 'It is a long established fact that a reader will be distracted by the readable content of a page.',
                            'icon_image_3' => $this->filePath('icons/icon-15.png'),
                            'bottom_description' => 'Need more help? Go to our',
                            'action_label' => 'Support Center',
                            'action_url' => '/contact',
                            'background_image' => $this->filePath('backgrounds/team.png'),
                        ],
                    ],
                    [
                        'name' => 'testimonials',
                        'attributes' => [
                            'style' => '2',
                            'title' => '<b> +100k users </b> have loved <br> <b> Infinia Conference </b> System',
                            'description' => 'Provide your team with top-tier group mentoring programs and exceptional professional benefits.',
                            'testimonial_ids' => '1,2,3,4,5,6',
                            'primary_action_label' => 'View More Testimonials',
                            'primary_action_icon' => 'ti ti-arrow-up-right',
                            'primary_action_url' => '/about-us',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
            [
                'name' => 'Book a demo',
                'content' => $this->generateShortcodeContent([
                    [
                        'name' => 'contact-form',
                        'attributes' => [
                            'display_fields' => 'phone,email,subject,address',
                            'mandatory_fields' => 'email',
                            'style' => '3',
                            'form_title' => 'Leave a message',
                            'form_description' => 'Need more help?',
                            'title' => 'Contact Our Team',
                            'subtitle' => 'Get in Tourch',
                            'description' => 'We are a comprehensive service agency with specialists prepared to assist. <br> We will contact you within 24 hours.',
                            'quantity' => '3',
                            'title_1' => 'Chat with us',
                            'description_1' => 'The support team is always available 24/7',
                            'button_label_1_1' => 'Chat via Whatsapp',
                            'button_url_1_1' => 'https://www.whatsapp.com',
                            'button_icon_1_1' => 'ti ti-brand-whatsapp',
                            'button_label_2_1' => 'Chat via Viber',
                            'button_url_2_1' => 'https://www.viber.com/',
                            'button_icon_2_1' => 'ti ti-phone-call',
                            'button_label_3_1' => 'Chat via Messager',
                            'button_url_3_1' => 'https://www.facebook.com/',
                            'button_icon_3_1' => 'ti ti-brand-messenger',
                            'title_2' => 'Send us an email',
                            'description_2' => 'Our team will respond promptly to your inquiries',
                            'button_label_1_2' => 'support@infinia.com',
                            'button_url_1_2' => 'mailto:support@infinia.com',
                            'button_icon_1_2' => 'ti ti-mail',
                            'button_label_2_2' => 'sale@infinia.com',
                            'button_url_2_2' => 'mailto:sale@infinia.com',
                            'button_icon_2_2' => 'ti ti-mail',
                            'title_3' => 'For more inquiry',
                            'description_3' => 'Reach out for immediate assistance',
                            'button_label_1_3' => '+01 (24) 568 900',
                            'button_url_1_3' => 'tell:0124568900',
                            'button_icon_1_3' => 'ti ti-phone-call',
                        ],
                    ],
                    [
                        'name' => 'site-statistics',
                        'attributes' => [
                            'title' => 'See why we are <br> trusted the world over',
                            'quantity' => '4',
                            'title_1' => 'New accounts',
                            'data_1' => '496',
                            'unit_1' => 'k',
                            'title_2' => 'Finished projects',
                            'data_2' => '92',
                            'unit_2' => '+',
                            'title_3' => 'Skilled experts',
                            'data_3' => '756',
                            'unit_3' => '+',
                            'title_4' => 'Media posts',
                            'data_4' => '25',
                            'unit_4' => 'k',
                        ],
                    ],
                    [
                        'name' => 'pricing-plans',
                        'attributes' => [
                            'style' => '3',
                            'title' => '<b>Straightforward</b>  Pricing <br> Custom <b>Integrations</b>',
                            'subtitle' => 'Our Pricing',
                            'description' => 'Meet the talented and passionate team members who drive our company forward every day.',
                            'quantity' => '6',
                            'package_ids' => '1,2,3',
                            'background_images' => $this->filePath('backgrounds/bg-line-bottom.png'),
                            'primary_action_label' => 'Get Free Quote',
                            'primary_action_url' => '/contact',
                            'primary_action_icon' => 'ti ti-arrow-narrow-right',
                            'secondary_action_label' => 'How We Work',
                            'secondary_action_url' => '/contact',
                        ],
                    ],
                ]),
                'template' => 'full-width',
                'metadata' => [
                    'breadcrumb_enabled' => '0',
                ],
            ],
        ]);
    }
}
