<?php

return [
    'name' => 'Produkter',
    'description' => 'Vis og opdater dine produktindstillinger',
    'create' => 'Nyt produkt',
    'create_product_type' => [
        'physical' => 'Nyt fysisk produkt',
        'digital' => 'Nyt digitalt produkt',
    ],
    'edit' => 'Rediger produkt - :name',
    'form' => [
        'name' => 'Navn',
        'name_placeholder' => 'Produktets navn (Maksimalt 120 tegn)',
        'description' => 'Beskrivelse',
        'description_placeholder' => 'Kort beskrivelse af produkt (Maksimalt 400 tegn)',
        'categories' => 'Kategorier',
        'content' => 'Indhold',
        'price' => 'Pris',
        'quantity' => 'Mængde',
        'brand' => 'Brand',
        'width' => 'Bredde',
        'height' => 'Højde',
        'weight' => 'Vægt',
        'date' => [
            'start' => 'Fra dato',
            'end' => 'Til dato',
        ],
        'image' => 'Billeder',
        'collections' => 'Produktsamlinger',
        'labels' => 'Etiketter',
        'price_sale' => 'Salgspris',
        'product_type' => [
            'title' => 'Produkttype',
        ],
        'product' => 'Produkt',
        'total' => 'Total',
        'sub_total' => 'Subtotal',
        'shipping_fee' => 'Fragtomkostning',
        'discount' => 'Rabat',
        'options' => 'Muligheder',
        'shipping' => [
            'height' => 'Højde',
            'length' => 'Længde',
            'title' => 'Fragt',
            'weight' => 'Vægt',
            'wide' => 'Bredde',
        ],
        'barcode' => 'Stregkode (ISBN, UPC, GTIN, osv.) ',
        'barcode_placeholder' => 'Indtast stregkode',
        'cost_per_item' => 'Omkostning per vare',
        'cost_per_item_placeholder' => 'Indtast omkostning per vare',
        'cost_per_item_helper' => 'Kunder vil ikke se denne pris.',
        'price_includes_tax' => 'Prisen inkluderer moms',
        'price_includes_tax_helper' => 'Marker dette, hvis den indtastede pris allerede inkluderer afgifter. Systemet vil beregne basisprisen ved at fjerne afgiftsbeløbet.',
        'stock' => [
            'allow_order_when_out' => 'Tillad kunde at betale når dette produkt er udsolgt',
            'in_stock' => 'På lager',
            'out_stock' => 'Udsolgt',
            'title' => 'Lagerstatus',
        ],
        'storehouse' => [
            'no_storehouse' => 'Ingen lagerstyring',
            'storehouse' => 'Med lagerstyring',
            'title' => 'Lager',
            'quantity' => 'Mængde',
        ],
        'tax' => 'Moms',
        'taxes' => 'Moms',
        'taxes_helper' => 'Standard momssatsen konfigureres i <a href=":url">Indstillinger -> Moms</a>. Hvis ingen specifik moms er valgt til dette produkt, anvendes standardsatsen. For at deaktivere moms for dette produkt skal du fjerne standard momssatsen fra momsindstillingerne.',
        'is_default' => 'Er standard',
        'action' => 'Handling',
        'restock_quantity' => 'Genopfyld antal',
        'remain' => 'Tilbage',
        'choose_discount_period' => 'Vælg rabatperiode',
        'cancel' => 'Annuller',
        'no_results' => 'Ingen resultater!',
        'value' => 'Værdi',
        'attribute_name' => 'Attributnavn',
        'add_more_attribute' => 'Tilføj flere attributter',
        'continue' => 'Fortsæt',
        'add_new_attributes' => 'Tilføj nye attributter',
        'add_new_attributes_description' => 'Tilføjelse af nye attributter hjælper produktet til at have mange muligheder, såsom størrelse eller farve.',
        'create_product_variations' => ':link for at oprette produktvarianter!',
        'tags' => 'Tags',
        'write_some_tags' => 'Skriv nogle tags',
        'variation_existed' => 'Denne variant eksisterer.',
        'no_attributes_selected' => 'Ingen attributter valgt!',
        'added_variation_success' => 'Variant tilføjet succesfuldt!',
        'updated_variation_success' => 'Variant opdateret succesfuldt!',
        'created_all_variation_success' => 'Alle varianter oprettet succesfuldt!',
        'updated_product_attributes_success' => 'Produktattributter opdateret succesfuldt!',
        'stock_status' => 'Lagerstatus',
        'auto_generate_sku' => 'Autogenerer SKU?',
        'featured_image' => 'Fremhævet billede (valgfrit)',
        'product_id' => 'Produkt-ID',
        'price_sale_percent_helper' => 'Rabat :percent fra originalpris.',
        'minimum_order_quantity' => 'Minimum ordreantal',
        'minimum_order_quantity_helper' => 'Minimum antal for at afgive en ordre, hvis værdien er 0, er der ingen grænse.',
        'maximum_order_quantity' => 'Maksimum ordreantal',
        'maximum_order_quantity_helper' => 'Maksimum antal for at afgive en ordre, hvis værdien er 0, er der ingen grænse.',
        'video' => 'Video',
        'video_file' => 'Fil',
        'video_url' => 'Eller ekstern video-URL',
        'video_url_help' => 'Indtast YouTube eller Vimeo video-URL',
        'enter_video_url' => 'Indtast video-URL',
        'video_thumbnail' => 'Video miniaturebillede',
        'video_thumbnail_help' => 'Vælg et miniaturebillede til videoen. Hvis det ikke er valgt, hentes det automatisk fra video-URL\'en hvis tilgængeligt.',
        'barcode_existed' => 'Denne stregkode bruges af et andet produkt. Indtast venligst en anden stregkode.',
        'barcode_helper' => 'Skal være unik for hvert produkt.',
        'is_new_until' => 'Ny indtil',
        'is_new_until_helper' => 'Indstil en dato, indtil hvilken dette produkt vil blive markeret som "Ny". Lad feltet være tomt for ikke at markere som ny baseret på dato.',
    ],
    'price' => 'Pris',
    'quantity' => 'Mængde',
    'type' => 'Type',
    'image' => 'Miniaturebillede',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'Variant SKU',
    'brand' => 'Brand',
    'cannot_delete' => 'Produktet kunne ikke slettes',
    'product_deleted' => 'Produkt slettet',
    'product_collections' => 'Produktsamlinger',
    'products' => 'Produkter',
    'menu' => 'Produkter',
    'control' => [
        'button_add_image' => 'Tilføj billede',
    ],
    'price_sale' => 'Salgspris',
    'price_group_title' => 'Administrer produktpris',
    'store_house_group_title' => 'Administrer lager',
    'shipping_group_title' => 'Administrer fragt',
    'overview' => 'Oversigt',
    'attributes' => 'Attributter',
    'product_has_variations' => 'Produktet har varianter',
    'manage_products' => 'Administrer produkter',
    'add_new_product' => 'Tilføj et nyt produkt',
    'start_by_adding_new_product' => 'Start med at tilføje nye produkter.',
    'edit_this_product' => 'Rediger dette produkt',
    'delete' => 'Slet',
    'related_products' => 'Relaterede produkter',
    'cross_selling_products' => 'Krydssalgsprodukter',
    'up_selling_products' => 'Mersalgsprodukter',
    'grouped_products' => 'Grupperede produkter',
    'search_products' => 'Søg produkter',
    'selected_products' => 'Valgte produkter',
    'edit_variation_item' => 'Rediger',
    'variations_box_description' => 'Klik på "Rediger attribut" for at tilføje/fjerne attributter af variant eller klik på "Tilføj ny variant" for at tilføje variant.',
    'save_changes' => 'Gem ændringer',
    'continue' => 'Fortsæt',
    'edit_attribute' => 'Rediger attribut',
    'select_attribute' => 'Vælg attribut',
    'add_new_variation' => 'Tilføj ny variant',
    'edit_variation' => 'Rediger variant',
    'generate_variations' => 'Generer varianter',
    'generate_variations_confirmation' => 'Er du sikker på, at du vil generere varianter for dette produkt?',
    'delete_variation' => 'Slet variant?',
    'delete_variation_confirmation' => 'Er du sikker på, at du vil slette denne variant? Denne handling kan ikke fortrydes.',
    'delete_variations_confirmation' => 'Er du sikker på, at du vil slette disse varianter? Denne handling kan ikke fortrydes.',
    'product_create_validate_name_required' => 'Indtast venligst produktets navn',
    'product_create_validate_sale_price_max' => 'Rabatten skal være mindre end originalprisen',
    'product_create_validate_cost_per_item_max' => 'Omkostning per vare skal være mindre end originalprisen',
    'product_create_validate_sale_price_required_if' => 'Skal indtaste en rabat når du vil planlægge en kampagne',
    'product_create_validate_end_date_after' => 'Slutdato skal være efter startdato',
    'product_create_validate_start_date_required_if' => 'Rabat startdato kan ikke være tom når planlægning er valgt',
    'product_create_validate_sale_price' => 'Rabatter kan ikke være tomme når planlægning er valgt',
    'stock_statuses' => [
        'in_stock' => 'På lager',
        'out_of_stock' => 'Udsolgt',
        'on_backorder' => 'På restordre',
    ],
    'stock_status' => 'Lagerstatus',
    'processing' => 'Behandler...',
    'delete_selected_variations' => 'Slet valgte varianter',
    'delete_variations' => 'Slet varianter',
    'category' => 'Kategori',
    'categories' => 'Kategorier',
    'tags' => 'Tags',
    'product_price_flash_sale_warning' => 'Dette produkt er på flash sale <strong>:name</strong> så dets pris er <strong>:price</strong>.',
    'product_price_discount_warning' => 'Dette produkt er på rabat <strong>:name</strong> så dets pris er <strong>:price</strong>.',
    'product_image' => 'Produktbillede',
    'product_name' => 'Produktnavn',
    'product_link' => 'Produktlink',
    'types' => [
        'physical' => 'Fysisk',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Digitale vedhæftninger',
        'add' => 'Tilføj vedhæftning',
        'file_name' => 'Filnavn',
        'file_size' => 'Filstørrelse',
        'unsaved' => 'Ikke gemt',
        'add_external_link' => 'Tilføj eksternt link',
        'enter_file_name' => 'Indtast filnavn',
        'enter_external_link_download' => 'Indtast eksternt downloadlink',
        'enter_file_size' => 'Indtast filstørrelse',
        'external_link_download' => 'Eksternt downloadlink',
        'generate_license_code_after_purchasing_product' => 'Aktiver licenskode tildeling for dette produkt',
        'notify_attachment_updated' => 'Send en e-mail til kunde når vedhæftningen er opdateret',
    ],
    'license_codes' => [
        'title' => 'Licenskoder',
        'add' => 'Tilføj licenskode',
        'back' => 'Tilbage til produkt',
        'edit' => 'Rediger licenskode',
        'generate' => 'Generer koder',
        'manage_codes' => 'Administrer licenskoder',
        'management' => 'Licenskode administration',
        'variation_breadcrumb' => 'Variant: :name',
        'variation_label' => 'Produktvariant',
        'variation_specific_note' => 'Disse licenskoder er specifikke for denne produktvariant. Kunder der køber denne variant vil modtage koder fra denne pulje.',
        'main_product_note' => 'Dette produkt har varianter. Hver variant kan have sine egne licenskoder, eller kunder kan modtage koder fra denne hovedprodukt pulje hvis varianten ikke har koder.',
        'code' => 'Licenskode',
        'codes' => 'Licenskoder',
        'status' => 'Status',
        'assigned_at' => 'Tildelt den',
        'status_available' => 'Tilgængelig',
        'status_used' => 'Brugt',
        'statuses' => [
            'available' => 'Tilgængelig',
            'used' => 'Brugt',
        ],
        'no_codes' => 'Ingen licenskoder fundet. Tilføj nogle koder eller generer dem automatisk.',
        'no_codes_warning_title' => 'Ingen licenskoder tilgængelige!',
        'no_codes_warning_message' => 'Dette produkt er indstillet til "Vælg fra liste" men har ingen tilgængelige licenskoder. Kunder der køber dette produkt vil modtage autogenererede koder i stedet. Tilføj venligst licenskoder for at sikre korrekt funktionalitet.',
        'no_codes_auto_generate' => 'Dette produkt er indstillet til at autogenerere licenskoder. Ingen manuelle koder nødvendige.',
        'used_code_no_actions' => 'Brugt kode - ingen handlinger tilgængelige',
        'created_successfully' => 'Licenskode oprettet succesfuldt!',
        'updated_successfully' => 'Licenskode opdateret succesfuldt!',
        'deleted_successfully' => 'Licenskode slettet succesfuldt!',
        'generated_successfully' => 'Genererede :count licenskoder succesfuldt!',
        'duplicates_skipped' => ':count duplikatkoder blev sprunget over.',
        'generation_incomplete' => 'Advarsel: Kunne kun generere :generated ud af :requested anmodede koder på grund af duplikatkonflikter.',
        'cannot_edit_used_code' => 'Kan ikke redigere en brugt licenskode.',
        'cannot_delete_used_code' => 'Kan ikke slette en brugt licenskode.',
        'show_all' => 'Vis alle',
        'show_less' => 'Vis mindre',
        'more' => 'mere',
        'used_codes_hidden' => ':count brugt(e) licenskode(r) er skjult. Du kan se alle koder på licenskode administrationsiden.',
        'low_stock_title' => 'Lavt licenskode lager',
        'low_stock_message' => 'Kun :count licenskoder tilbage. Overvej at tilføje flere koder for at undgå at løbe tør.',
        'out_of_stock_title' => 'Løbet tør for licenskoder!',
        'out_of_stock_message' => 'Ingen licenskoder tilgængelige. Kunder vil modtage autogenererede koder indtil du tilføjer flere.',
        'type' => [
            'title' => 'Licenskode tildelingsmetode',
            'auto_generate' => 'Autogenerer (System genererer koder automatisk)',
            'pick_from_list' => 'Vælg fra liste (Brug forudindtastede koder)',
            'description' => 'Vælg hvordan licenskoder skal tildeles til kunder når de køber dette produkt.',
        ],
        'generate_modal' => [
            'title' => 'Generer licenskoder',
            'quantity' => 'Mængde',
            'format' => 'Format',
            'custom_pattern' => 'Tilpasset mønster',
            'pattern_help' => 'Brug # for tal, A for store bogstaver, a for små bogstaver',
            'generate' => 'Generer',
        ],
        'errors' => [
            'feature_not_enabled' => 'Licenskoder funktion er ikke aktiveret. Aktiver venligst den i E-handel indstillinger > Digitale produkter.',
            'digital_products_not_enabled' => 'Digitale produkter er ikke aktiveret. Aktiver venligst digitale produkter support først.',
            'product_not_found' => 'Produkt ikke fundet.',
            'not_digital_product' => 'Licenskoder er kun tilgængelige for digitale produkter. Dette produkt er indstillet som et fysisk produkt.',
            'license_codes_not_enabled_for_product' => 'Licenskode administration er ikke aktiveret for dette produkt. Aktiver venligst "Generer licenskode efter køb af produkt" i produktindstillingerne.',
            'cannot_add_codes_auto_generate' => 'Kan ikke manuelt tilføje licenskoder til produkter indstillet til autogenerer. Skift licenskode typen til "Vælg fra liste" først.',
            'cannot_generate_codes_auto_generate' => 'Kan ikke manuelt generere licenskoder for produkter indstillet til autogenerer. Skift licenskode typen til "Vælg fra liste" først.',
        ],
        'copied' => 'Licenskode kopieret til udklipsholder!',
    ],
    'this_action_will_reload_page' => 'Denne handling vil genindlæse siden for at opdatere dataene!',
    'select' => 'Vælg',
    'set_this_variant_as_default' => 'Indstil denne variant som standard',
    'download' => 'Download',
    'cross_sell_price_type' => [
        'title' => 'Pristype',
        'fixed' => 'Fast',
        'percent' => 'Procent',
    ],
    'cross_sell_help' => [
        'price' => 'Pris',
        'price_description' => 'Indtast beløbet du vil reducere fra originalprisen. Eksempel: Hvis originalprisen er 100 kr, indtast 20 for at reducere prisen til 80 kr.',
        'type' => '* Type felt',
        'type_description' => 'Vælg rabattypen: Fast (reducer et specifikt beløb) eller Procent (reducer med en procent).',
    ],
    'apply_for_all_variations' => 'Anvend for alle varianter',
    'export' => [
        'description' => 'Eksporter dine produktdata til CSV eller Excel-filer.',
        'total_items' => 'Total varer',
        'total_products' => 'Total produkter',
        'total_variations' => 'Total varianter',
        'advanced_options' => 'Avancerede muligheder',
        'use_chunked_export' => 'Brug chunked eksport',
        'use_chunked_export_helper' => 'Behandl data i chunks for at håndtere store datasæt effektivt',
        'include_variations' => 'Inkluder produktvarianter',
        'include_variations_helper' => 'Eksporter produktvarianter sammen med hovedprodukter',
        'optimize_memory' => 'Optimer hukommelsesforbrug',
        'optimize_memory_helper' => 'Aktiver hukommelsesoptimering for meget store eksporter',
        'chunk_size' => 'Chunk størrelse',
        'chunk_size_helper' => 'Antal produkter til behandling ad gangen (50-5000)',
        'use_streaming' => 'Brug streaming eksport',
        'use_streaming_helper' => 'Aktiver streaming for meget store datasæt (automatisk aktiveret for >10.000 varer)',
        'large_dataset_warning_title' => 'Stort produktkatalog opdaget',
        'large_dataset_warning_message' => 'Dit katalog indeholder :count varer. På grund af den store størrelse er nogle eksportmuligheder blevet optimeret for bedste ydeevne.',
        'large_dataset_specific_message' => 'For dine :count produkter, brug CSV-format med streaming aktiveret. Systemet kan nu håndtere dit store produktkatalog effektivt uden timeouts eller hukommelsesproblemer.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Påkrævet)',
        'chunk_label' => 'Behandling',
        'chunk_recommended' => '300 produkter/batch',
        'time_label' => 'Forventet tid',
        'time_estimate' => '1-3 minutter',
        'pro_tip' => 'Pro tip:',
        'pro_tip_message' => 'Eksporten fortsætter med at køre, selvom din browser viser en indlæsningsindikator. Når den er startet, begynder downloaden automatisk.',
        'large_dataset_tip_1' => 'Excel-format er blevet deaktiveret - brug CSV-format for hurtigere og mere pålidelige eksporter',
        'large_dataset_tip_2' => 'Streaming-tilstand er automatisk blevet aktiveret for at forhindre timeouts',
        'large_dataset_tip_3' => 'Eksportproces kan tage 1-3 minutter afhængigt af din server',
        'large_dataset_recommendation' => 'Anbefalet: Brug CSV-format med 200-500 chunk størrelse for optimal ydeevne.',
        'excel_disabled_for_large_export' => 'Excel-format ikke tilgængeligt for kataloger over 10.000 varer',
        'streaming_auto_enabled' => 'Streaming-tilstand er automatisk blevet aktiveret for optimal ydeevne med store datasæt.',
        'streaming_enabled_title' => 'Optimeret til stor eksport',
        'streaming_enabled_message' => 'Streaming-tilstand er aktiv for at sikre glat eksport uden hukommelsesproblemer.',
        'use_multi_file' => 'Brug multi-fil eksport',
        'use_multi_file_helper' => 'Opdel eksport i flere filer pakket i en ZIP for meget store datasæt',
        'multi_file_enabled_title' => 'Multi-fil eksport aktiveret',
        'multi_file_enabled_message' => 'Din eksport opdeles i :count filer pakket i en ZIP for optimal ydeevne.',
        'records_per_file' => 'Poster per fil',
        'records_per_file_helper' => 'Antal poster i hver fil ved brug af multi-fil eksport',
        'estimated_files' => 'Forventede filer',
        'recommended_range' => 'Anbefalet interval',
        'range_large_export' => '200-500 varer',
        'range_medium_export' => '300-800 varer',
        'range_small_export' => '500-1000 varer',
        'export_progress' => 'Eksport fremskridt',
        'preparing_export' => 'Forbereder eksport...',
        'items_processed' => ':count varer behandlet',
        'estimated_time_calculating' => 'Forventet tid: beregner...',
        'medium_dataset_detected' => 'Mellemstort datasæt opdaget',
        'medium_dataset_message' => 'Du eksporterer :count produkter. Overvej at bruge chunked eksport for bedre ydeevne.',
        'optimal_range' => 'Optimal interval',
        'too_small_slow' => 'For lille - kan være langsom',
        'too_large_timeouts' => 'For stor - kan forårsage timeouts',
        'excel_disabled_warning' => 'Excel-format deaktiveret for store eksporter (:count varer)',
        'starting_export' => 'Starter eksport...',
        'processing_data' => 'Behandler data...',
        'finalizing_export' => 'Færdiggør eksport...',
        'items_processed_suffix' => 'varer behandlet',
        'estimated_time_prefix' => 'Forventet tid:',
        'seconds_remaining' => 's tilbage',
        'export_completed' => 'Eksport gennemført!',
        'download_starting' => 'Download starter...',
    ],
    'import' => [
        'description' => 'Importer dine produktdata fra CSV eller Excel-filer.',
        'rules' => [
            'in' => ':attribute skal være en af de definerede værdier: :values.',
            'required_string_max' => ':attribute er påkrævet og skal være en streng med en maksimal længde på :max tegn.',
            'nullable_string' => ':attribute kan være tom eller skal være en streng hvis angivet.',
            'nullable_string_max' => ':attribute kan være tom eller skal være en streng med en maksimal længde på :max tegn hvis angivet',
            'nullable_bool' => 'Om :attribute kan være tom eller skal være en boolsk værdi hvis angivet.',
            'nullable_numeric_min' => ':attribute kan være tom eller skal være et ikke-negativt tal hvis angivet.',
            'nullable_numeric_min_max' => ':attribute kan være tom eller skal være et tal mellem :min og :max hvis angivet.',
            'nullable_array' => ':attribute kan være tom eller skal angives som et array hvis specificeret.',
            'nullable_date_required_if' => ':attribute kan være tom eller skal være en gyldig dato hvis angivet, påkrævet hvis :required er specificeret.',
            'nullable_date_after' => ':attribute kan være tom eller skal være en gyldig dato efter :after hvis angivet.',
        ],
        'updated_message' => 'Opdaterede :count produkter succesfuldt!',
    ],
    'import_products_intro' => 'Eller importer produkter fra CSV/Excel',
    'select_attributes' => 'Vælg attributter for at oprette varianter:',
    'all' => 'Alle',
    'copy' => 'Kopier',
    'product_translations' => 'Produktoversættelser',
    'view' => 'Se produkt - :name',
    'product_information' => 'Produktinformation',
    'total_views' => 'Samlede Visninger',
    'total_orders' => 'Gennemførte Ordrer',
    'total_sold' => 'Solgt i Alt',
    'total_revenue' => 'Samlet Indtægt',
    'pending_orders' => 'Afventende ordrer',
    'pending_revenue' => 'Afventende omsætning',
    'conversion_rate' => 'Konverteringsrate',
    'total_reviews' => 'Samlede Anmeldelser',
    'average_rating' => 'Gennemsnitlig Bedømmelse',
    'views_by_date' => 'Visninger efter Dato (Sidste 30 Dage)',
    'recent_orders' => 'Seneste Ordrer',
    'no_views_data' => 'Ingen visningsdata tilgængelige for de sidste 30 dage.',
    'no_orders' => 'Ingen ordrer endnu.',
    'date' => 'Dato',
    'views' => 'Visninger',
    'total' => 'I alt',
    'view_on_frontend' => 'Se på hjemmesiden',
    'select_attribute' => 'Vælg :name',
    'all_categories' => 'Alle kategorier',
    'brands' => 'Mærker',
    'browse_products' => 'Gennemse produkter',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Vælg produkter til returnering',
    'show_only_discounted_products' => 'Vis kun produkter på tilbud',
    'specification' => 'Specifikation',
    'download_product_with_external_links' => 'Download produkt ":name" med eksterne links',
    'number_product_available_singular' => ':number produkt tilgængeligt',
    'number_products_available_plural' => ':number produkter tilgængelige',
];
