<?php

return [
    'save_settings' => 'Shrani nastavitev',
    'ecommerce' => 'Ecommerce',
    'general' => [
        'name' => 'Splošno',
        'description' => 'Ime trgovine, podatki podjetja, kontakt in admin obvestilni e-maili',
    ],
    'currency' => [
        'name' => 'Valute',
        'description' => 'Formati valut, menjalnih tečajev, samodejno zaznavanje in decimalni/tisočni ločevalniki',
        'currency_setting_description' => 'Oglejte si in posodobite valute, ki se uporabljajo na spletni strani',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Omogoči samodejno zaznavanje valute obiskovalca',
            'enable_auto_detect_visitor_currency_helper' => 'Samodejno zazna in prikaže cene v lokalni valuti obiskovalca glede na njihovo lokacijo. To zagotavlja bolj personalizirano nakupovalno izkušnjo.',
            'add_space_between_price_and_currency' => 'Dodaj presledek med ceno in valuto',
            'add_space_between_price_and_currency_helper' => 'Ko je omogočeno, doda presledek med vrednostjo cene in simbolom valute (npr. "100 EUR" namesto "100EUR").',
            'thousands_separator' => 'Ločilo tisočic',
            'thousands_separator_helper' => 'Izberite znak za ločevanje tisočic pri prikazu cene (npr. 1.000 ali 1,000 ali 1 000).',
            'decimal_separator' => 'Decimalno ločilo',
            'decimal_separator_helper' => 'Izberite znak za ločevanje decimalnih vrednosti v cenah (npr. 10,99 ali 10.99).',
            'separator_period' => 'Pika (.)',
            'separator_comma' => 'Vejica (,)',
            'separator_space' => 'Presledek ( )',
            'api_key' => 'API ključ menjalnih tečajev',
            'api_key_helper' => 'Pridobite API ključ menjalnih tečajev na :link',
            'update_currency_rates' => 'Posodobi menjalne tečaje',
            'use_exchange_rate_from_api' => 'Uporabi menjalni tečaj iz API-ja',
            'use_exchange_rate_from_api_helper' => 'Omogoči samodejne posodobitve menjalnih tečajev valut iz konfiguriranega ponudnika API. To zagotavlja, da so vaše cene vedno posodobljene s trenutnimi tržnimi tečaji.',
            'clear_cache_rates' => 'Počisti predpomnjene tečaje',
            'auto_detect_visitor_currency_description' => 'Zazna valuto obiskovalca na podlagi jezika brskalnika. To bo preglasilo privzeto izbiro valute.',
            'exchange_rate' => [
                'api_provider' => 'Ponudnik API',
                'select' => '-- Izberi --',
                'none' => 'Brez',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Za privzeto valuto mora biti menjalni tečaj 1.',
        ],
    ],
    'product' => [
        'name' => 'Izdelki',
        'description' => 'Prikaz zalog, generiranje SKU, slike variant, povezani izdelki in specifikacije',
        'product_settings' => 'Nastavitve izdelkov',
        'product_settings_description' => 'Konfigurirajte pravila za izdelke',
        'form' => [
            'show_number_of_products' => 'Prikaži število izdelkov na strani posameznega izdelka',
            'show_number_of_products_helper' => 'Prikaži skupno število izdelkov na strani s podrobnostmi izdelka.',
            'show_out_of_stock_products' => 'Prikaži izdelke, ki niso na zalogi',
            'show_out_of_stock_products_helper' => 'Če je omogočeno, bodo izdelki, ki niso na zalogi, prikazani na strani s seznamom izdelkov.',
            'how_to_display_product_variation_images' => 'Kako prikazati slike variacij izdelka',
            'how_to_display_product_variation_images_helper' => 'Izberite, ali naj se prikažejo samo slike specifične za variacije ali vključite slike variacij in glavnega izdelka.',
            'only_variation_images' => 'Samo slike variacij',
            'variation_images_and_main_product_images' => 'Slike variacij in slike glavnega izdelka',
            'enable_product_options' => 'Omogoči možnosti izdelka',
            'enable_product_options_helper' => 'Dovoli izdelkom, da imajo prilagodljive možnosti, kot so velikost, barva itd.',
            'is_enabled_cross_sale_products' => 'Omogoči navzkrižno prodajane izdelke',
            'is_enabled_cross_sale_products_helper' => 'Prikaži predloge navzkrižno prodajanih izdelkov za spodbujanje dodatnih nakupov.',
            'is_enabled_related_products' => 'Omogoči sorodne izdelke',
            'is_enabled_related_products_helper' => 'Prikaži sorodne izdelke glede na kategorijo ali izbrano s strani skrbnika v obrazcu izdelka.',
            'related_products_source' => 'Vir sorodnih izdelkov',
            'related_products_source_helper' => 'Ko skrbnik ne izbere sorodnih izdelkov v obrazcu izdelka, prikaži sorodne izdelke glede na ta vir.',
            'related_products_source_category' => 'Enaka kategorija',
            'related_products_source_brand' => 'Enaka blagovna znamka',
            'trending_products_period' => 'Obdobje priljubljenih izdelkov',
            'trending_products_period_helper' => 'Izberite časovno obdobje za upoštevanje pri izračunu priljubljenih izdelkov glede na število ogledov.',
            'trending_products_period_1_day' => 'Zadnjih 24 ur',
            'trending_products_period_3_days' => 'Zadnje 3 dni',
            'trending_products_period_7_days' => 'Zadnjih 7 dni (1 teden)',
            'trending_products_period_14_days' => 'Zadnjih 14 dni (2 tedna)',
            'trending_products_period_30_days' => 'Zadnjih 30 dni (1 mesec)',
            'trending_products_period_60_days' => 'Zadnjih 60 dni (2 meseca)',
            'trending_products_period_90_days' => 'Zadnjih 90 dni (3 mesece)',
            'auto_generate_product_sku' => 'Samodejno generiraj SKU pri ustvarjanju izdelka',
            'auto_generate_product_sku_helper' => 'Samodejno generiraj edinstvene SKU-je za nove izdelke glede na spodnji format.',
            'product_sku_format' => 'Format SKU',
            'product_sku_format_helper' => 'V formatu lahko uporabite %s (1 znak niza) ali %d (1 števka) za generiranje naključnega niza. Npr.: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Omogoči specifikacijo izdelka',
            'enable_product_specification_help' => 'Če je omogočeno, bo tabela specifikacij izdelka prikazana na strani s podrobnostmi izdelka.',
            'make_product_barcode_required' => 'Naredite črtno kodo izdelka obvezno',
            'make_product_barcode_required_helper' => 'Če je omogočeno, bo črtna koda izdelka obvezna pri ustvarjanju izdelka.',
        ],
    ],
    'product_search' => [
        'name' => 'Iskanje izdelkov',
        'description' => 'Obnašanje iskanja, filtri po kategoriji/blagovni znamki/oznaki/atributih in filtriranje cenovnega razpona',
        'product_search_settings' => 'Iskanje izdelkov',
        'product_search_settings_description' => 'Konfigurirajte pravila za iskanje izdelkov',
        'form' => [
            'search_for_an_exact_phrase' => 'Išči natančno frazo',
            'search_products_by' => 'Iskanje izdelkov po:',
            'enable_filter_products_by_categories' => 'Omogoči filtriranje izdelkov po kategorijah',
            'enable_filter_products_by_brands' => 'Omogoči filtriranje izdelkov po blagovnih znamkah',
            'enable_filter_products_by_tags' => 'Omogoči filtriranje izdelkov po oznakah',
            'number_of_popular_tags_for_filter' => 'Število priljubljenih oznak za filter',
            'number_of_popular_tags_for_filter_placeholder' => 'Vnesite število priljubljenih oznak za prikaz',
            'number_of_popular_tags_for_filter_helper' => 'Nastavite največje število priljubljenih oznak za prikaz v filtru. Privzeto je 10.',
            'enable_filter_products_by_attributes' => 'Omogoči filtriranje izdelkov po atributih',
            'enable_filter_products_by_price' => 'Omogoči filtriranje izdelkov po ceni',
            'max_product_price_for_filter' => 'Maksimalna cena izdelka za filter',
            'max_product_price_for_filter_placeholder' => 'Če je prazno ali nič, bo pridobljena maksimalna cena izdelka iz vaših obstoječih izdelkov.',
            'max_product_price_for_filter_helper' => 'Lahko nastavite fiksno ceno za to ali pa bo dinamično pridobljena maksimalna cena izdelka iz vaših obstoječih izdelkov. Trenutno je :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Digitalni izdelki',
        'description' => 'Prenosljivi izdelki, licenčne kode, blagajna za goste za digitalne izdelke in samodejno dokončanje',
        'digital_products_settings' => 'Digitalni izdelki',
        'digital_products_settings_description' => 'Konfigurirajte pravila za digitalne izdelke',
        'form' => [
            'enable_support_digital_product' => 'Je omogočena podpora digitalnim izdelkom',
            'enable_support_digital_product_helper' => 'Ko je omogočeno, bo sistem podpiral prodajo digitalnih izdelkov, kot so programska oprema, e-knjige, glasba in druga vsebina za prenos.',
            'allow_guest_checkout_for_digital_products' => 'Dovoli plačilo gosta za digitalne izdelke',
            'allow_guest_checkout_for_digital_products_helper' => 'Ko je omogočeno, lahko stranke kupijo digitalne izdelke brez ustvarjanja računa. Povezave za prenos bodo prejele po e-pošti.',
            'disable_physical_product' => 'Onemogoči fizične izdelke',
            'disable_physical_product_helper' => 'Ko je omogočeno, bo trgovina prodajala samo digitalne izdelke. Možnosti fizičnih izdelkov bodo skrite iz obrazcev izdelkov in plačila.',
            'enable_license_codes_for_digital_products' => 'Omogoči licenčne kode za digitalne izdelke',
            'auto_complete_digital_orders_after_payment' => 'Samodejno zaključi digitalna naročila po plačilu',
            'auto_complete_digital_orders_after_payment_helper' => 'Ko je omogočeno, bodo naročila, ki vsebujejo samo digitalne izdelke, samodejno označena kot zaključena, ko je plačilo prejeto.',
            'enable_license_codes_for_digital_products_helper' => 'Ko je omogočeno, lahko dodate licenčne kode digitalnim izdelkom. Ko je onemogočeno, bo funkcionalnost licenčnih kod skrita iz obrazcev izdelkov.',
            'hide_used_license_codes_in_product_form' => 'Skrij uporabljene licenčne kode v obrazcu izdelka',
            'hide_used_license_codes_in_product_form_helper' => 'Ko je omogočeno, bodo uporabljene licenčne kode skrite iz tabele licenčnih kod v obrazcu za urejanje izdelka. To pomaga ohranjati vmesnik čist, ko imate veliko uporabljenih kod.',
        ],
    ],
    'product_review' => [
        'name' => 'Ocene izdelkov',
        'description' => 'Ocene strank, prikaz ocen, nalaganje slik in zahteve za odobritev',
        'form' => [
            'enable_review' => 'Omogoči ocene izdelkov',
            'enable_review_help' => 'Dovoli strankam, da pustijo ocene in ocenjevanja izdelkov. Ko je onemogočeno, bodo vse funkcije ocenjevanja skrite iz trgovine.',
            'allow_customer_upload_image_in_review' => 'Dovoli strankam nalaganje slik v ocenah',
            'allow_customer_upload_image_in_review_help' => 'Ko je onemogočeno, stranke ne morejo naložiti slik pri oddaji ocen',
            'review' => [
                'max_file_size' => 'Maksimalna velikost datoteke ocene (MB)',
                'max_file_number' => 'Maksimalno število datotek ocene',
            ],
            'only_allow_customers_purchased_to_review' => 'Samo stranke, ki so kupile izdelek, lahko ocenijo izdelek',
            'review_need_to_be_approved' => 'Ocena mora biti odobrena pred prikazom na strani izdelka',
            'show_customer_full_name' => 'Prikaži polno ime stranke',
            'show_customer_full_name_help' => 'Če ni označeno, bo ime stranke, ki ocenjuje, skrito in nadomeščeno z zvezdico (***)',
            'hide_rating_when_no_reviews' => 'Skrij ocenjevanje, ko ni ocen',
            'hide_rating_when_no_reviews_help' => 'Ko je omogočeno, bodo ocene izdelkov skrite v seznamih izdelkov in straneh s podrobnostmi izdelka, ko izdelek nima ocen',
            'display_uploaded_customer_review_images_list' => 'Prikaži razdelek "Slike od strank"',
            'display_uploaded_customer_review_images_list_help' => 'Ko je omogočeno, prikaže galerijo vseh slik, ki so jih naložile stranke na vrhu razdelka ocen',
        ],
    ],
    'shopping' => [
        'name' => 'Nakupovanje',
        'description' => 'Košarica, seznam želja, primerjava, sledenje naročil, gumb hitrega nakupa in nalaganje dokazil o plačilu',
        'general_setting' => 'Splošne nastavitve',
        'return_settings' => 'Nastavitve vračil',
        'return_settings_description' => 'Konfigurirajte pravila za nastavitve vračil',
        'form' => [
            'enable_cart' => 'Omogoči nakupovalno košarico',
            'enable_cart_helper' => 'Če je onemogočeno, bo gumb košarice odstranjen, kar bo vašo stran spremenilo v prikaz samo kataloga.',
            'enable_wishlist' => 'Omogoči seznam želja',
            'enable_wishlist_helper' => 'Če je onemogočeno, bo gumb seznama želja odstranjen s strani.',
            'enable_wishlist_sharing' => 'Omogoči deljenje seznama želja',
            'shared_wishlist_lifetime' => 'Življenjska doba deljenega seznama želja (dnevi)',
            'shared_wishlist_lifetime_helper' => 'Življenjska doba deljenega seznama želja v dnevih. Po tem času bo deljeni seznam želja izbrisan.',
            'enable_compare' => 'Omogoči primerjavo',
            'enable_compare_helper' => 'Če je onemogočeno, bo gumb za primerjavo odstranjen s strani.',
            'enable_order_tracking' => 'Omogoči sledenje naročilom',
            'enable_order_tracking_helper' => 'Stranke lahko sledijo svojim naročilom z vnosom kode naročila in e-pošte/telefona na :url',
            'order_tracking_method' => 'Način sledenja naročila',
            'order_tracking_method_helper' => 'Izberite, kako bodo stranke sledile svojim naročilom: z uporabo ID naročila + e-pošta ali ID naročila + telefonska številka.',
            'order_tracking_method_email' => 'ID naročila + e-pošta',
            'order_tracking_method_phone' => 'ID naročila + telefonska številka',
            'enable_quick_buy_button' => 'Omogoči gumb za hiter nakup',
            'enable_quick_buy_button_helper' => 'Prikaže gumb Kupi zdaj na strani s seznamom izdelkov in strani s podrobnostmi. Ko stranke kliknejo na ta gumb, bo izdelek dodan v košarico in preusmerjeno na stran košarice/plačila.',
            'enable_order_auto_confirmed' => 'Samodejno potrdi naročilo',
            'enable_order_auto_confirmed_helper' => 'Če je omogočeno, bo naročilo samodejno potrjeno po tem, ko stranka odda naročilo.',
            'quick_buy_target' => 'Ciljna stran hitrega nakupa',
            'checkout_page' => 'Stran plačila',
            'cart_page' => 'Stran košarice',
            'cart_destroy_on_logout' => 'Uniči košarico ob odjavi',
            'cart_destroy_on_logout_helper' => 'Košarica bo uničena, ko se stranka odjavi.',
            'hide_product_price' => 'Skrij ceno izdelka',
            'hide_product_price_helper' => 'Ta možnost deluje samo, če onemogočite nakupovalno košarico, kar spremeni vašo stran v prikaz samo kataloga. Če je omogočeno, bo cena izdelka skrita. To je koristno, ko želite skriti ceno in zahtevati, da stranke kontaktirajo vas za ceno.',
            'hide_product_price_when_zero' => 'Skrij ceno izdelka, ko je nič',
            'hide_product_price_when_zero_helper' => 'Če je omogočeno, izdelki s ceno 0 v trgovini ne bodo prikazovali cene.',
            'enable_payment_proof' => 'Omogoči nalaganje dokazila o plačilu',
            'enable_payment_proof_helper' => 'Dovoli strankam, da naložijo dokazilo o plačilu za svoja naročila. To je koristno za ročne načine plačila.',
            'enable_guest_payment_proof' => 'Dovoli gostujočim strankam nalaganje dokazila o plačilu',
            'enable_guest_payment_proof_helper' => 'Ko je omogočeno, lahko gostujoče stranke naložijo dokazilo o plačilu z uporabo svojega žetona naročila brez prijave. Povezavo za nalaganje bodo prejele v svoji potrditveni e-pošti naročila.',
            'payment_proof_payment_methods' => 'Načini plačila, ki zahtevajo potrdilo o plačilu',
            'payment_proof_payment_methods_helper' => 'Izberite, kateri načini plačila naj strankam omogočijo nalaganje potrdila o plačilu. Običajno se uporablja za ročne načine plačila, kot sta plačilo po povzetju in bančno nakazilo.',
        ],
    ],
    'checkout' => [
        'name' => 'Plačilo',
        'panel_description' => 'Blagajna za goste, obvezna polja, omejitve naročil, sprejem pogojev in omejitve držav',
        'description' => 'Konfigurirajte pravila za nastavitve plačila',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Prikaži bančne informacije na strani uspešnega plačila',
            'mandatory_form_fields_at_checkout' => 'Obvezna polja na strani plačila:',
            'mandatory_form_fields_at_checkout_helper' => 'Izberite, katera polja so obvezna med plačilom. Stranke morajo izpolniti ta polja za zaključitev naročila.',
            'hide_form_fields_at_checkout' => 'Skrij polja strank na strani plačila:',
            'hide_form_fields_at_checkout_helper' => 'Izberite, katera polja naj bodo skrita na strani plačila. Ta polja ne bodo vidna strankam.',
            'load_countries_states_cities_from_location_plugin' => 'Naloži države, regije, mesta iz vtičnika za lokacijo',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Po spremembi te možnosti morate ponovno posodobiti vse naslove. To nastavite enkrat.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Nato morate iti na Orodja -> Uvoz/izvoz podatkov za uvoz podatkov o lokaciji.',
            'minimum_order_amount' => 'Minimalni znesek naročila za oddajo naročila (:currency).',
            'minimum_order_amount_helper' => 'Nastavite minimalni skupni znesek, potreben za obdelavo naročila. Naročila pod tem zneskom ne bodo sprejeta.',
            'zip_code_enabled' => 'Omogoči poštno številko',
            'zip_code_enabled_helper' => 'Omogoči ali onemogoči polje za poštno številko v obrazcu za naslov dostave.',
            'billing_address_enabled' => 'Omogoči naslov za račun',
            'billing_address_enabled_helper' => 'Dovoli strankam, da vnesejo ločen naslov za račun, ki se razlikuje od njihovega naslova dostave.',
            'display_tax_fields_at_checkout_page' => 'Prikaži polja davčnih informacij na strani plačila',
            'display_tax_fields_at_checkout_page_helper' => 'Če je omogočeno, bodo polja davčnih informacij prikazana za vnos davčnih podatkov podjetja za prejem računa.',
            'use_city_field_as_field_text' => 'Uporabi polje mesta kot prosto besedilno polje',
            'available_countries' => 'Razpoložljive države',
            'all' => 'Vse',
            'all_helper_text' => 'Če odstranite oznako vseh držav, bo veljalo za vse države.',
            'enable_guest_checkout' => 'Omogoči plačilo gosta',
            'enable_guest_checkout_helper' => 'Če je omogočeno, lahko stranke oddajo naročilo brez ustvarjanja računa.',
            'recently_viewed' => [
                'enable' => 'Omogoči nedavno ogledane izdelke stranke',
                'enable_helper' => 'Sledite in prikažite izdelke, ki so jih stranke nedavno ogledale. To pomaga strankam enostavno najti izdelke, ki so jih zanimali.',
                'max' => 'Maksimalno število nedavno ogledanih izdelkov stranke',
                'max_helper_text' => 'Če je nastavljeno na 0, omejitve ni.',
            ],
            'minimum_order_quantity' => 'Minimalna količina naročila',
            'minimum_order_quantity_helper' => 'Minimalna količina za oddajo naročila. Naj bo 0, če tega ne želite nastaviti.',
            'maximum_order_quantity' => 'Maksimalna količina naročila',
            'maximum_order_quantity_helper' => 'Maksimalna količina za oddajo naročila. Naj bo 0, če tega ne želite nastaviti.',
            'default_country_at_checkout_page' => 'Privzeta država na strani plačila',
            'default_country_at_checkout_page_placeholder' => 'Izberite državo',
            'default_country_at_checkout_page_help' => 'Če izberete državo, bo ta država privzeto izbrana na strani plačila.',
            'checkout_product_quantity_editable' => 'Dovoli strankam spreminjanje količine izdelka na strani plačila',
            'checkout_product_quantity_editable_helper' => 'Ko je omogočeno, lahko stranke spremenijo količino izdelkov neposredno na strani plačila brez vračanja v košarico.',
            'show_terms_and_policy_checkbox' => 'Prikaži potrditveno polje pogojev in politike',
            'show_terms_and_policy_checkbox_helper' => 'Če je omogočeno, morajo stranke pred oddajo naročila soglašati s pogoji in politiko. Najprej nastavite URL pogojev in politike zasebnosti v Videz -> Možnosti teme.',
            'terms_and_policy_checkbox_checked_by_default' => 'Potrditveno polje pogojev in politike privzeto označeno',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Če je omogočeno, bo potrditveno polje pogojev in politike predhodno označeno, ko se obrazec za plačilo naloži.',
            'checkout_acceptance_message_enabled' => 'Prikaži sporočilo o sprejetju plačila',
            'checkout_acceptance_message_enabled_helper' => 'Prikaži informativno sporočilo, ki obvešča stranke o pogojih, s katerimi se strinjajo z oddajo naročila.',
            'hide_customer_info_at_checkout' => 'Skrij informacije o stranki pri plačilu',
            'hide_customer_info_at_checkout_helper' => 'Skrij informacije o računu stranke in gumb za odjavo s strani plačila. Ko je omogočeno, prijavljene stranke ne bodo videle prikazanih podatkov svojega računa.',
        ],
    ],
    'return' => [
        'name' => 'Vračilo',
        'description' => 'Konfigurirajte pravila za nastavitve vračil',
        'panel_description' => 'Vračila naročil, delna vračila in roki za vračilo',
        'form' => [
            'is_enabled_order_return' => 'Je omogočeno vračilo naročila',
            'allow_partial_return' => 'Dovoli delno vračilo',
            'allow_partial_return_description' => 'Stranka lahko vrne nekaj izdelkov, ni potrebno vrniti vseh izdelkov v naročilu.',
            'returnable_days' => 'Dnevi za vračilo',
            'return_settings_helper' => 'Število dni, ko lahko stranka zahteva vračilo po zaključku naročila.',
        ],
    ],
    'invoice' => [
        'name' => 'Računi',
        'description' => 'Podatki podjetja na računih, številčenje računov, PDF pisave in nastavitve žiga',
        'company_settings' => 'Nastavitve podjetja',
        'company_settings_description' => 'Nastavitve informacij o podjetju za izdajo računov',
        'form' => [
            'company_name' => 'Ime podjetja',
            'company_address' => 'Naslov podjetja',
            'company_zipcode' => 'Poštna številka podjetja',
            'company_email' => 'E-pošta podjetja',
            'company_phone' => 'Telefon podjetja',
            'company_logo' => 'Logotip podjetja',
            'company_tax_id' => 'Davčna številka podjetja',
            'invoice_code_prefix' => 'Predpona kode računa',
            'using_custom_font_for_invoice' => 'Uporaba pisave po meri za račun',
            'invoice_font_family' => 'Družina pisav računa (Deluje samo za latinske jezike)',
            'enable_invoice_stamp' => 'Omogoči žig računa',
            'add_language_support' => 'Dodaj podporo za jezik',
            'invoice_processing_library' => 'Knjižnica za obdelavo računov',
            'only_latin_languages' => 'Samo latinski jeziki',
            'disable_order_invoice_until_order_confirmed' => 'Onemogoči račun naročila do potrditve naročila',
            'date_format' => 'Format datuma',
            'languages' => [
                'arabic' => 'Arabščina',
                'bangladesh' => 'Bengalščina',
                'chinese' => 'Kitajščina',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Davek',
        'description' => 'Nastavitve davka',
        'enable' => 'Omogoči davek?',
        'display_product_price_including_taxes' => 'Prikaži ceno izdelka z davki?',
        'display_tax_description' => 'Prikaži davčne informacije na ceni izdelka?',
        'display_tax_description_help' => 'Prikaži besedilo kot "(Vključno z X% DDV)" ali "(Brez X% DDV)" poleg cen izdelkov na strani s podrobnostmi izdelka.',
        'tax_included_in_products_price' => 'Davek vključen v ceno izdelkov',
        'tax_included_in_products_price_description' => 'Davek bo vključen v ceno izdelkov',
        'tax_setting' => 'Nastavitve davka',
        'tax_setting_description' => 'Konfigurirajte nastavitve davka',
        'tax_management' => 'Upravljanje davkov',
        'tax_management_description' => 'Oglejte si in upravljajte svoje davke',
        'form' => [
            'enable_tax' => 'Omogoči davek',
            'display_company_invoice_information_fields_at_checkout_page' => 'Prikaži polja informacij o računu podjetja na strani plačila',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Če je omogočeno, bodo polja informacij o računu podjetja prikazana na strani plačila. Obvezno je izpolniti polja informacij o računu podjetja.',
            'default_tax_rate' => 'Privzeta davčna stopnja',
            'default_tax_rate_description' => 'Pomembno: Uporabljena bo, če v izdelku ni izbran noben davek.',
            'select_tax' => '-- Izberi --',
            'display_product_price_including_taxes' => 'Dodaj davek prikazanim cenam',
            'display_product_price_including_taxes_helper' => 'Samodejno doda davek cenam izdelkov v trgovini. Npr. izdelek za $100 z 10% davkom se prikaže kot $110. Ni potrebno, če je "Cena vključuje davek" že omogočeno pri posameznih izdelkih.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Stranke',
        'description' => 'Registracija, preverjanje e-pošte, možnosti prijave, brisanje računa in polja profila',
        'customer_setting' => 'Nastavitve strank',
        'customer_setting_description' => 'Konfigurirajte nastavitve strank',
        'form' => [
            'enable_customer_registration' => 'Omogoči registracijo strank',
            'enable_customer_registration_helper' => 'Če je onemogočeno, stranke ne bodo mogle registrirati novih računov. Obstoječe stranke se lahko še vedno prijavijo.',
            'verify_customer_email' => 'Preveri e-pošto stranke',
            'verify_customer_email_helper' => 'Ko je omogočeno, bo povezava za potrditev poslana na e-pošto stranke, stranke morajo klikniti na to povezavo za potrditev svoje e-pošte, preden se lahko prijavijo. Konfigurirajte e-pošto v Skrbnik -> Nastavitve -> E-pošta za pošiljanje potrditvene e-pošte.',
            'verification_expire_minutes' => 'Čas poteka povezave za potrditev',
            'verification_expire_minutes_helper' => 'Čas v minutah, ko bo povezava za potrditev e-pošte veljavna. Privzeto je 60 minut (1 ura). Maksimalno je 10080 minut (7 dni).',
            'login_using_phone' => 'Prijavite se s telefonsko številko namesto e-pošte',
            'login_option' => 'Možnost prijave',
            'login_with_email' => 'Prijava z e-pošto',
            'login_with_phone' => 'Prijava s telefonom',
            'login_with_email_or_phone' => 'Prijava z e-pošto ali telefonom',
            'enabled_customer_account_deletion' => 'Omogoči brisanje računa stranke',
            'enabled_customer_account_deletion_helper' => 'Ko je omogočeno, lahko stranke izbrišejo svoj račun v nadzorni plošči stranke → Nastavitve računa.',
            'enabled_customer_dob_field' => 'Omogoči polje za datum rojstva stranke',
            'enabled_customer_dob_field_helper' => 'Ko je omogočeno, lahko stranke vnesejo svoj datum rojstva v nadzorni plošči stranke → Nastavitve računa.',
            'enabled_phone_field_in_registration_form' => 'Omogoči polje telefona v registracijskem obrazcu',
            'enabled_phone_field_in_registration_form_helper' => 'Ko je omogočeno, bo polje telefona dodano registracijskemu obrazcu.',
            'make_customer_phone_number_required' => 'Naredite telefonsko številko stranke obvezno',
            'make_customer_phone_number_required_helper' => 'Ko je omogočeno, morajo stranke vnesti svojo telefonsko številko med registracijo. Vedno je obvezno za stranke, ki se prijavljajo s telefonsko številko.',
            'default_avatar' => 'Privzeta profilna slika',
            'default_avatar_helper' => 'Privzeta profilna slika za stranko, ko nimajo profilne slike. Če ne izberete nobene slike, bo generirana z uporabo vašega logotipa ali prvega znaka imena stranke.',
            'keep_email_field_in_registration_form' => 'Ohrani polje e-pošte v registracijskem obrazcu',
            'keep_email_field_in_registration_form_helper' => 'Ko je onemogočeno, bo polje e-pošte skrito v registracijskem obrazcu, ko je možnost prijave "Prijava s telefonom".',
        ],
    ],
    'shipping' => [
        'name' => 'Dostava',
        'description' => 'Pravila dostave, obnašanje brezplačne dostave in vrstni red prikaza možnosti dostave',
        'shipping_rule' => 'Pravila dostave',
        'shipping_rule_description' => 'Konfigurirajte pravila za izračun stroškov dostave',
        'shipping_setting' => 'Nastavitve dostave',
        'shipping_setting_description' => 'Konfigurirajte nastavitve dostave',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Skrij druge možnosti dostave, če ima brezplačno dostavo na seznamu',
            'disable_shipping_options' => 'Onemogoči možnosti dostave',
            'disable_shipping_options_helper' => 'Možnosti dostave bodo odstranjene na strani plačila, stranka ne bo mogla izbrati možnosti dostave.',
            'sort_shipping_options_direction' => 'Smer razvrščanja možnosti dostave',
            'sort_shipping_options_direction_helper' => 'Razvrsti možnosti dostave po ceni od nižje k višji ali od višje k nižji.',
            'price_lower_to_higher' => 'Cena od nižje k višji',
            'price_higher_to_lower' => 'Cena od višje k nižji',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Konfigurirajte nastavitve webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Konfigurirajte URL-je webhook za prejemanje obvestil za različne dogodke naročil',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook oddanega naročila (metoda: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Za prejemanje obvestil, ko je naročilo oddano, lahko nastavite zunanji URL webhook. Če imate zunanji URL webhook, lahko vnesete ta URL ali ga pustite praznega.',
            'order_updated_webhook_url' => 'URL webhook posodobljenega naročila (metoda: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Za prejemanje obvestil, ko je naročilo posodobljeno, lahko nastavite zunanji URL webhook. To vključuje spremembe statusa, posodobitve naslova in druge spremembe naročila.',
            'shipping_status_updated_webhook_url' => 'URL webhook posodobljenega statusa dostave (metoda: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Za prejemanje obvestil, ko se spremeni status dostave (npr. poslano, dostavljeno, preklicano), lahko nastavite zunanji URL webhook.',
            'order_completed_webhook_url' => 'URL webhook zaključenega naročila (metoda: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Za prejemanje obvestil, ko je naročilo zaključeno, lahko nastavite zunanji URL webhook.',
            'order_cancelled_webhook_url' => 'URL webhook preklica naročila (metoda: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Za prejemanje obvestil, ko je naročilo preklicano, lahko nastavite zunanji URL webhook.',
            'payment_status_updated_webhook_url' => 'URL webhook posodobljenega statusa plačila (metoda: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Za prejemanje obvestil, ko se spremeni status plačila (npr. plačano, neuspelo, vrnjeno), lahko nastavite zunanji URL webhook.',
            'abandoned_cart_webhook_url' => 'URL webhook zapuščene košarice (metoda: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Za prejemanje obvestil, ko so košarice zapuščene in nadaljnje spremljanje strank, lahko nastavite zunanji URL webhook. Obvestila so poslana po nastavljivem časovnem obdobju.',
        ],
        'test_button' => 'Testiraj Webhook',
        'test_success' => 'Test webhook-a uspešen! Končna točka se je pravilno odzvala.',
        'test_failed' => 'Test webhook-a ni uspel. Končna točka se ni odzvala kot pričakovano.',
        'test_error' => 'Napaka pri testu webhook-a: :error',
        'please_enter_url' => 'Najprej vnesite URL webhook',
        'testing' => 'Testiranje...',
        'test_failed_title' => 'Test ni uspel!',
        'test_success_title' => 'Test uspešen!',
        'status_code' => 'Koda statusa',
        'error_occurred' => 'Pri testiranju webhook-a je prišlo do napake',
    ],
    'store_locator' => [
        'name' => 'Lokatorji trgovin',
        'description' => 'Oglejte si in posodobite sezname svojih verig',
        'store_locator_description' => 'Vsi seznami vaših verig, glavnih trgovin, podružnic itd. Lokacije lahko uporabimo za sledenje prodaje in pomoč pri konfiguraciji davčnih stopenj za zaračunavanje pri prodaji izdelkov.',
        'form' => [
            'change_primary_store' => 'spremeni privzet lokator trgovine',
            'add_location' => 'Dodaj lokacijo',
            'edit_location' => 'Uredi lokacijo',
            'delete_location' => 'Izbriši lokacijo',
            'delete_location_confirmation' => 'Ali ste prepričani, da želite izbrisati to lokacijo? Tega dejanja ni mogoče razveljaviti.',
            'change_primary_location' => 'Spremeni primarno lokacijo',
            'save_location' => 'Shrani lokacijo',
            'add_new' => 'Dodaj novo',
        ],
            'info' => [
            'title' => 'Kako delujejo lokatorji trgovin',
            'primary_store' => 'Naslov glavne trgovine se prikaže na računih in se uporablja kot privzeti naslov za vračilo za nalepke za pošiljanje.',
            'shipping_location' => 'Trgovine, označene kot "lokacija pošiljanja", je mogoče izbrati kot izvorno skladišče pri ustvarjanju pošiljk.',
            'shipment_selection' => 'Pri obdelavi naročil lahko izberete, iz katerega skladišča poslati, glede na zaloge in lokacijo stranke.',
        ],
    ],
    'tracking' => [
        'name' => 'Sledenje',
        'description' => 'Facebook Pixel, dogodki Google Tag Manager in sledenje konverzijam Google Ads',
        'manage_tracking' => 'Upravljanje sledenja',
        'manage_tracking_description' => 'Upravljanje sledenja: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Omogoči Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Pojdite na https://developers.facebook.com/docs/meta-pixel za ustvarjanje Facebook Pixel. Prepričajte se, da je vaš pixel aktiven in pravilno konfiguriran.',
            'facebook_pixel_id' => 'ID Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Primer: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Omogoči način odpravljanja napak Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Omogočite način odpravljanja napak za beleženje dogodkov Facebook Pixel v konzolo brskalnika in odpravljanje težav s sledenjem',
            'enable_google_tag_manager_tracking_events' => 'Omogoči dogodke sledenja Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Ko je omogočeno, bodo dogodki e-trgovine sledeni prek Google Tag Manager. Prepričajte se, da ste zgoraj konfigurirali Google Tag Manager.',
            'google_ads_conversion_id' => 'ID konverzije Google Ads',
            'google_ads_conversion_id_helper' => 'Vnesite svoj ID konverzije Google Ads (format: AW-123456789/AbC-D_efG-h1_ijk-lmN) za sledenje nakupnim konverzijam na strani zahvale.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'ID Facebook Pixel mora biti 15-16 števk (npr. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Tržnica',
        'description' => 'Nastavitve več prodajalcev, provizije, registracija prodajalcev in konfiguracija izplačil',
    ],
    'standard_and_format' => [
        'name' => 'Standard in format',
        'panel_description' => 'Format kode naročila, enote teže (kg/lb) in enote dimenzij (cm/palec)',
        'description' => 'Standardi in formati se uporabljajo za izračun stvari, kot so cene izdelkov, teže pošiljanja in časi naročil.',
        'form' => [
            'change_order_format' => 'Uredi format kode naročila (neobvezno)',
            'change_order_format_description' => 'Privzeta koda naročila se začne pri: številka. Začetni ali končni niz lahko spremenite za ustvarjanje kode naročila, ki jo želite, na primer "DH-: številka" ali ": številka-A"',
            'start_with' => 'Začni z',
            'end_with' => 'Končaj z',
            'order_will_be_shown' => 'Vaša koda naročila bo prikazana',
            'weight_unit' => 'Enota teže',
            'height_unit' => 'Enota dolžine / višine',
            'weight_unit_gram' => 'Gram (g)',
            'weight_unit_kilogram' => 'Kilogram (kg)',
            'weight_unit_lb' => 'Funt (lb)',
            'weight_unit_oz' => 'Unča (oz)',
            'height_unit_cm' => 'Centimeter (cm)',
            'height_unit_m' => 'Meter (m)',
            'height_unit_inch' => 'Palec',
        ],
    ],
    'sale_popup' => [
        'name' => 'Pojavno okno prodaje',
        'description' => 'Enostavno prilagodite nastavitve pojavnega okna prodaje',
    ],
    'flash_sale' => [
        'name' => 'Hitra razprodaja',
        'description' => 'Konfigurirajte nastavitve hitre razprodaje za ponudbo časovno omejenih promocijskih popustov',
        'enable' => 'Omogoči funkcionalnost hitre razprodaje',
        'enable_helper' => 'Ko je omogočeno, lahko ustvarite in upravljate hitre razprodaje s posebnimi znižanimi cenami za omejeno časovno obdobje.',
        'show_sale_count_left' => 'Prikaži sledilec zaloge',
        'show_sale_count_left_description' => 'Prikaži vrstico napredka z "X prodanih od Y" za ustvarjanje nujnosti in spodbujanje hitrih nakupov med hitrimi razprodajami.',
    ],
    'payment_method_cod_minimum_amount' => 'Minimalni znesek naročila - :currency (neobvezno)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Minimalni znesek naročila - :currency (neobvezno)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Prikaži bančne informacije na strani uspešnega plačila?',
    'invoice_templates' => 'Predloge računov',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
